/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job;

import com.google.common.base.Verify;
import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.BuildStepListener;
import hudson.tasks.BuildStep;
import io.jenkins.plugins.opentelemetry.JenkinsControllerOpenTelemetry;
import io.jenkins.plugins.opentelemetry.JenkinsOpenTelemetryPluginConfiguration;
import io.jenkins.plugins.opentelemetry.OtelUtils;
import io.jenkins.plugins.opentelemetry.job.MonitoringRunListener;
import io.jenkins.plugins.opentelemetry.job.OtelTraceService;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import jenkins.YesNoMaybe;

@Extension(dynamicLoadable=YesNoMaybe.YES)
public class MonitoringBuildStepListener
extends BuildStepListener {
    protected static final Logger LOGGER = Logger.getLogger(MonitoringRunListener.class.getName());
    private OtelTraceService otelTraceService;
    private Tracer tracer;

    public void started(AbstractBuild build, BuildStep buildStep, BuildListener listener) {
        String stepName = JenkinsOpenTelemetryPluginConfiguration.get().findSymbolOrDefault(buildStep.getClass().getSimpleName(), buildStep);
        try (Scope ignored = this.setupContext(build, buildStep);){
            Verify.verifyNotNull((Object)ignored, (String)"%s - No span found for step %s", (Object[])new Object[]{build, buildStep});
            SpanBuilder spanBuilder = this.getTracer().spanBuilder(stepName);
            JenkinsOpenTelemetryPluginConfiguration.StepPlugin stepPlugin = JenkinsOpenTelemetryPluginConfiguration.get().findStepPluginOrDefault(stepName, buildStep);
            String jenkinsVersion = OtelUtils.getJenkinsVersion();
            spanBuilder.setParent(Context.current()).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_NAME, (Object)stepName).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_PLUGIN_NAME, (Object)(stepPlugin.isUnknown() ? "jenkins-core" : stepPlugin.getName())).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_PLUGIN_VERSION, (Object)(stepPlugin.isUnknown() ? jenkinsVersion : stepPlugin.getVersion()));
            Span atomicStepSpan = spanBuilder.startSpan();
            LOGGER.log(Level.FINE, () -> build.getFullDisplayName() + " - > " + stepName + " - begin " + OtelUtils.toDebugString(atomicStepSpan));
            this.getTracerService().putSpan(build, buildStep, atomicStepSpan);
        }
    }

    public void finished(AbstractBuild build, BuildStep buildStep, BuildListener listener, boolean canContinue) {
        String stepName = JenkinsOpenTelemetryPluginConfiguration.get().findSymbolOrDefault(buildStep.getClass().getSimpleName(), buildStep);
        try (Scope ignored = this.setupContext(build, buildStep);){
            Verify.verifyNotNull((Object)ignored, (String)"%s - No span found for step %s", (Object[])new Object[]{build, buildStep});
            Span span = this.getTracerService().getSpan(build, buildStep);
            if (canContinue) {
                span.setStatus(StatusCode.OK);
            } else {
                JenkinsOpenTelemetryPluginConfiguration.StepPlugin stepPlugin = JenkinsOpenTelemetryPluginConfiguration.get().findStepPluginOrDefault(stepName, buildStep);
                if (stepPlugin.isUnknown()) {
                    String jenkinsVersion = OtelUtils.getJenkinsVersion();
                    stepPlugin = new JenkinsOpenTelemetryPluginConfiguration.StepPlugin("jenkins-core", jenkinsVersion);
                }
                span.recordException((Throwable)new AbortException("StepName: " + stepName + ", " + String.valueOf(stepPlugin)));
                span.setStatus(StatusCode.ERROR, "Build step failed");
            }
            span.end();
            this.getTracerService().removeBuildStepSpan(build, buildStep, span);
            LOGGER.log(Level.FINE, () -> build.getFullDisplayName() + " - < " + stepName + " - end " + OtelUtils.toDebugString(span));
        }
    }

    @MustBeClosed
    @NonNull
    protected Scope setupContext(AbstractBuild<?, ?> build, @NonNull BuildStep buildStep) {
        Verify.verifyNotNull(build, (String)"%s No build found for step %s", (Object[])new Object[]{build, buildStep});
        Span span = this.otelTraceService.getSpan(build, buildStep);
        return span.makeCurrent();
    }

    @Inject
    public final void setOpenTelemetryTracerService(@NonNull OtelTraceService otelTraceService) {
        this.otelTraceService = otelTraceService;
    }

    @NonNull
    public OtelTraceService getTracerService() {
        return this.otelTraceService;
    }

    @NonNull
    public Tracer getTracer() {
        return Objects.requireNonNull(this.tracer, "Null Tracer, #postConstruct has not bee invoked on listener.");
    }

    public String toString() {
        return "MonitoringBuildStepListener{}";
    }

    @Inject
    public void setTracer(JenkinsControllerOpenTelemetry jenkinsControllerOpenTelemetry) {
        this.tracer = jenkinsControllerOpenTelemetry.getDefaultTracer();
    }
}

