/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.job;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import hudson.model.Run;
import io.jenkins.plugins.opentelemetry.JenkinsOpenTelemetryPluginConfiguration;
import io.jenkins.plugins.opentelemetry.OtelUtils;
import io.jenkins.plugins.opentelemetry.job.action.AbstractMonitoringAction;
import io.jenkins.plugins.opentelemetry.job.action.FlowNodeMonitoringAction;
import io.opentelemetry.api.trace.Span;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class MonitoringAction
extends AbstractMonitoringAction
implements Action,
RunAction2,
SimpleBuildStep.LastBuildAction {
    private static final Logger LOGGER = Logger.getLogger(MonitoringAction.class.getName());
    @Deprecated(since="2.15.1", forRemoval=true)
    private String rootSpanName = super.getSpanName();
    @Deprecated(since="2.15.1", forRemoval=true)
    private Map<String, String> rootContext = super.getW3cTraceContext();
    private transient Run run;

    public MonitoringAction(Span span) {
        super(span, Collections.emptyList());
    }

    public void onAttached(Run<?, ?> r) {
        this.run = r;
    }

    public void onLoad(Run<?, ?> r) {
        this.run = r;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "OpenTelemetry";
    }

    public Collection<? extends Action> getProjectActions() {
        return this.run.getParent().getLastSuccessfulBuild().getActions(MonitoringAction.class);
    }

    public String getUrlName() {
        return null;
    }

    protected Object readResolve() {
        if (this.rootContext != null && this.w3cTraceContext == null) {
            LOGGER.log(Level.FINEST, () -> "Migrate rootContext='" + String.valueOf(this.rootContext) + "' on " + System.identityHashCode(this));
            this.w3cTraceContext = this.rootContext;
            this.rootContext = null;
        }
        if (this.rootSpanName != null && this.spanName == null) {
            LOGGER.log(Level.FINEST, () -> "Migrate rootSpanName='" + this.rootSpanName + "' on " + System.identityHashCode(this));
            this.spanName = this.rootSpanName;
            this.rootSpanName = null;
        }
        return this;
    }

    @CheckForNull
    public Map<String, String> getW3cTraceContext(@NonNull String flowNodeId) {
        Optional<FlowNode> flowNode = Optional.ofNullable(((WorkflowRun)this.run).getExecution()).map(flowExecution -> {
            try {
                return flowExecution.getNode(flowNodeId);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failure to retrieve flow node " + flowNodeId, e);
                return null;
            }
        });
        return flowNode.flatMap(node -> ImmutableList.copyOf((Collection)node.getActions(FlowNodeMonitoringAction.class)).reverse().stream().findFirst().map(AbstractMonitoringAction::getW3cTraceContext)).orElseGet(() -> this.run.getActions(MonitoringAction.class).stream().findFirst().map(AbstractMonitoringAction::getW3cTraceContext).orElse(Collections.emptyMap()));
    }

    @NonNull
    public List<ObservabilityBackendLink> getLinks() {
        List tracingCapableBackends = JenkinsOpenTelemetryPluginConfiguration.get().getObservabilityBackends().stream().filter(backend -> backend.getTraceVisualisationUrlTemplate() != null).collect(Collectors.toList());
        if (tracingCapableBackends.isEmpty()) {
            return Collections.singletonList(new ObservabilityBackendLink("Please define an OpenTelemetry Visualisation URL of pipelines in Jenkins configuration", Jenkins.get().getRootUrl() + "/configure", "icon-gear2", null));
        }
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put("serviceName", Objects.requireNonNull(JenkinsOpenTelemetryPluginConfiguration.get().getServiceName()));
        binding.put("serviceNamespace", JenkinsOpenTelemetryPluginConfiguration.get().getServiceNamespace());
        binding.put("rootSpanName", this.rootSpanName == null ? null : OtelUtils.urlEncode(this.rootSpanName));
        binding.put("traceId", this.getTraceId());
        binding.put("spanId", this.getSpanId());
        binding.put("startTime", Instant.ofEpochMilli(this.run.getStartTimeInMillis()));
        return tracingCapableBackends.stream().map(backend -> new ObservabilityBackendLink("View pipeline with " + backend.getName(), backend.getTraceVisualisationUrl(binding), backend.getIconPath(), backend.getEnvVariableName())).collect(Collectors.toList());
    }

    public static class ObservabilityBackendLink {
        final String label;
        final String url;
        final String iconClass;
        final String environmentVariableName;

        public ObservabilityBackendLink(String label, String url, String iconClass, String environmentVariableName) {
            this.label = label;
            this.url = url;
            this.iconClass = iconClass;
            this.environmentVariableName = environmentVariableName;
        }

        public String getLabel() {
            return this.label;
        }

        public String getUrl() {
            return this.url;
        }

        public String getIconClass() {
            return this.iconClass;
        }

        public String getEnvironmentVariableName() {
            return this.environmentVariableName;
        }

        public String toString() {
            return "ObservabilityBackendLink{label='" + this.label + "', url='" + this.url + "', iconUrl='" + this.iconClass + "', environmentVariableName='" + this.environmentVariableName + "'}";
        }
    }
}

