/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.jenkins;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.slaves.ComputerListener;
import io.jenkins.plugins.opentelemetry.JenkinsOpenTelemetryPluginConfiguration;
import io.jenkins.plugins.opentelemetry.OpenTelemetryConfiguration;
import io.jenkins.plugins.opentelemetry.api.OpenTelemetryLifecycleListener;
import io.jenkins.plugins.opentelemetry.opentelemetry.GlobalOpenTelemetrySdk;
import io.jenkins.plugins.opentelemetry.semconv.ConfigurationKey;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.semconv.ServiceAttributes;
import io.opentelemetry.semconv.incubating.ServiceIncubatingAttributes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;

@Extension(ordinal=2.147483647E9)
public class OpenTelemetryConfigurerComputerListener
extends ComputerListener
implements OpenTelemetryLifecycleListener {
    private static final Logger logger = Logger.getLogger(OpenTelemetryConfigurerComputerListener.class.getName());
    final AtomicBoolean buildAgentsInstrumentationEnabled = new AtomicBoolean(false);
    JenkinsOpenTelemetryPluginConfiguration jenkinsOpenTelemetryPluginConfiguration;

    public void preOnline(Computer computer, Channel channel, FilePath root, TaskListener listener) {
        if (!this.buildAgentsInstrumentationEnabled.get()) {
            return;
        }
        OpenTelemetryConfiguration openTelemetryConfiguration = this.jenkinsOpenTelemetryPluginConfiguration.toOpenTelemetryConfiguration();
        Map<String, String> otelSdkProperties = openTelemetryConfiguration.toOpenTelemetryProperties();
        Map<String, String> otelSdkResourceProperties = openTelemetryConfiguration.toOpenTelemetryResourceAsMap();
        try {
            Object result = this.configureOpenTelemetrySdkOnComputer(computer, (VirtualChannel)channel, otelSdkProperties, otelSdkResourceProperties).get();
            logger.log(Level.FINE, () -> "Updated OpenTelemetry configuration for computer/build-agent '" + computer.getName() + "' with result: " + String.valueOf(result));
        }
        catch (InterruptedException e) {
            logger.log(Level.INFO, e, () -> "Failure to update OpenTelemetry configuration for computer/build-agent '" + computer.getName() + "'");
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            logger.log(Level.INFO, e, () -> "Failure to update OpenTelemetry configuration for computer/build-agent '" + computer.getName() + "'");
        }
    }

    @Inject
    public void setJenkinsOpenTelemetryPluginConfiguration(JenkinsOpenTelemetryPluginConfiguration jenkinsOpenTelemetryPluginConfiguration) {
        this.jenkinsOpenTelemetryPluginConfiguration = jenkinsOpenTelemetryPluginConfiguration;
    }

    public void afterConfiguration(@NonNull ConfigProperties configProperties) {
        OpenTelemetryConfiguration openTelemetryConfiguration = this.jenkinsOpenTelemetryPluginConfiguration.toOpenTelemetryConfiguration();
        boolean otlpLogsEnabled = "otlp".equals(configProperties.getString("otel.logs.exporter"));
        boolean jenkinsAgentInstrumentationDisabled = "false".equalsIgnoreCase(configProperties.getString(ConfigurationKey.OTEL_INSTRUMENTATION_JENKINS_AGENTS_ENABLED.asProperty()));
        this.buildAgentsInstrumentationEnabled.set(otlpLogsEnabled || !jenkinsAgentInstrumentationDisabled);
        if (!this.buildAgentsInstrumentationEnabled.get()) {
            return;
        }
        Map<String, String> otelSdkProperties = openTelemetryConfiguration.toOpenTelemetryProperties();
        Map<String, String> otelSdkResourceProperties = openTelemetryConfiguration.toOpenTelemetryResourceAsMap();
        Computer[] computers = Jenkins.get().getComputers();
        ArrayList configureAgentResults = new ArrayList(computers.length);
        Arrays.stream(computers).forEach(computer -> {
            Node node = computer.getNode();
            VirtualChannel channel = computer.getChannel();
            logger.log(Level.FINE, () -> "Evaluate computer.name: '" + computer.getName() + "', node: " + String.valueOf(Optional.ofNullable(node).map(n -> n.getNodeName() + " / " + n.getClass().getName())));
            if (!(node instanceof Jenkins)) {
                if (channel == null) {
                    logger.log(Level.FINE, () -> "Failure to update OpenTelemetry configuration for computer/build-agent '" + computer.getName() + "' as its channel is null, probably offline");
                } else {
                    configureAgentResults.add(this.configureOpenTelemetrySdkOnComputer((Computer)computer, channel, otelSdkProperties, otelSdkResourceProperties));
                }
            }
        });
        configureAgentResults.forEach(result -> {
            try {
                result.get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                logger.log(Level.WARNING, e, () -> "Failure to update OpenTelemetry configuration for computer/build-agent");
            }
        });
    }

    private Future<Object> configureOpenTelemetrySdkOnComputer(@Nonnull Computer computer, @Nonnull VirtualChannel channel, Map<String, String> otelSdkProperties, Map<String, String> otelSdkResourceProperties) {
        Set<String> filteredResourceKeys = Set.of(ServiceAttributes.SERVICE_NAME.getKey(), ServiceIncubatingAttributes.SERVICE_INSTANCE_ID.getKey());
        HashMap<String, String> buildAgentOtelSdkProperties = new HashMap<String, String>(otelSdkProperties);
        HashMap<String, String> buildAgentOtelSdkResourceProperties = new HashMap<String, String>();
        otelSdkResourceProperties.entrySet().stream().filter(Predicate.not(entry -> filteredResourceKeys.contains(entry.getKey()))).forEach(entry -> buildAgentOtelSdkResourceProperties.put((String)entry.getKey(), (String)entry.getValue()));
        String serviceName = Optional.ofNullable(otelSdkResourceProperties.get(ServiceAttributes.SERVICE_NAME.getKey())).orElse("jenkins");
        buildAgentOtelSdkResourceProperties.put(ServiceAttributes.SERVICE_NAME.getKey(), serviceName);
        buildAgentOtelSdkResourceProperties.put(ExtendedJenkinsAttributes.JENKINS_COMPUTER_NAME.getKey(), computer.getName());
        buildAgentOtelSdkResourceProperties.put(ExtendedJenkinsAttributes.JENKINS_COMPUTER_NAME.getKey(), computer.getName());
        OpenTelemetryConfigurerMasterToSlaveCallable callable = new OpenTelemetryConfigurerMasterToSlaveCallable(buildAgentOtelSdkProperties, buildAgentOtelSdkResourceProperties);
        try {
            logger.log(Level.FINE, () -> "Updating OpenTelemetry configuration for computer/build-agent '" + computer.getName() + "'...");
            return channel.callAsync((Callable)callable);
        }
        catch (IOException | RuntimeException e) {
            logger.log(Level.INFO, e, () -> "Failure to update OpenTelemetry configuration for computer/build-agent '" + computer.getName() + "'");
            return CompletableFuture.completedFuture(e);
        }
    }

    public static class OpenTelemetryConfigurerMasterToSlaveCallable
    extends MasterToSlaveCallable<Object, RuntimeException> {
        static final Logger logger = Logger.getLogger(OpenTelemetryConfigurerMasterToSlaveCallable.class.getName());
        final Map<String, String> otelSdkConfigurationProperties;
        final Map<String, String> otelSdkResource;

        public OpenTelemetryConfigurerMasterToSlaveCallable(Map<String, String> otelSdkConfigurationProperties, Map<String, String> otelSdkResource) {
            this.otelSdkConfigurationProperties = otelSdkConfigurationProperties;
            this.otelSdkResource = otelSdkResource;
        }

        public Object call() throws RuntimeException {
            logger.log(Level.FINE, () -> "Configure OpenTelemetry SDK with properties: " + String.valueOf(this.otelSdkConfigurationProperties) + ", resource:" + String.valueOf(this.otelSdkResource));
            GlobalOpenTelemetrySdk.configure(this.otelSdkConfigurationProperties, this.otelSdkResource, true);
            return null;
        }
    }
}

