/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.jenkins;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.Secret;
import io.jenkins.plugins.opentelemetry.jenkins.CredentialsNotFoundException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import jenkins.model.Jenkins;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.plaincredentials.impl.StringCredentialsImpl;
import org.springframework.security.core.Authentication;

public class HttpAuthHeaderFactory {
    private static final String AUTHORIZATION = "Authorization";
    private static final String BASIC_AUTH_FORMAT = "Basic %s";
    private static final String API_KEY_FORMAT = "ApiKey %s";
    private static final String BEARER_FORMAT = "Bearer %s";
    private static final String DIGEST_FORMAT_STRING = "%s:%s";
    private final Boolean bearerMode;
    private Credentials jenkinsCredentials;

    public HttpAuthHeaderFactory(String jenkinsCredentialsId) {
        this(jenkinsCredentialsId, (Boolean)false);
    }

    public HttpAuthHeaderFactory(Credentials jenkinsCredentials) {
        this(jenkinsCredentials, (Boolean)false);
    }

    public HttpAuthHeaderFactory(Credentials jenkinsCredentials, Boolean bearerMode) {
        this.jenkinsCredentials = jenkinsCredentials;
        this.bearerMode = bearerMode;
    }

    public HttpAuthHeaderFactory(String jenkinsCredentialsId, Boolean bearerMode) {
        this.jenkinsCredentials = this.getJenkinsCredentials(jenkinsCredentialsId);
        this.bearerMode = bearerMode;
    }

    private Credentials getJenkinsCredentials(String jenkinsCredentialsId) throws CredentialsNotFoundException {
        Credentials credentials = null;
        if (jenkinsCredentialsId == null || jenkinsCredentialsId.isEmpty()) {
            throw new CredentialsNotFoundException("No Jenkins credentials defined");
        }
        try {
            credentials = CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(Credentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM2, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)jenkinsCredentialsId));
        }
        catch (NoSuchElementException e) {
            throw new CredentialsNotFoundException("No Jenkins credentials found for id '" + jenkinsCredentialsId + "'");
        }
        if (credentials == null) {
            throw new CredentialsNotFoundException("No Jenkins credentials found for id '" + jenkinsCredentialsId + "'");
        }
        return credentials;
    }

    public Header createAuthHeader() throws CredentialsNotFoundException {
        Credentials credentials = this.jenkinsCredentials;
        if (credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials usernamePassword = (UsernamePasswordCredentials)credentials;
            return this.createAuthHeader(usernamePassword);
        }
        credentials = this.jenkinsCredentials;
        if (credentials instanceof StringCredentials) {
            StringCredentials stringCredentials = (StringCredentials)credentials;
            return this.createAuthHeader(stringCredentials);
        }
        throw new CredentialsNotFoundException("Incorrect credentials type, supported are StringCredentials and UsernamePasswordCredentials");
    }

    private Header createAuthHeader(StringCredentials stringCredentials) {
        String valueformat = this.bearerMode != false ? BEARER_FORMAT : API_KEY_FORMAT;
        String value = String.format(valueformat, stringCredentials.getSecret().getPlainText());
        return new BasicHeader(AUTHORIZATION, (Object)value);
    }

    private Header createAuthHeader(@NonNull UsernamePasswordCredentials jenkinsCredentials) throws CredentialsNotFoundException {
        if (jenkinsCredentials == null) {
            throw new CredentialsNotFoundException("No Jenkins credentials set");
        }
        String username = jenkinsCredentials.getUsername();
        String password = jenkinsCredentials.getPassword().getPlainText();
        String digest = Base64.getEncoder().encodeToString(String.format(DIGEST_FORMAT_STRING, username, password).getBytes(StandardCharsets.UTF_8));
        String value = String.format(BASIC_AUTH_FORMAT, digest);
        return new BasicHeader(AUTHORIZATION, (Object)value);
    }

    @NonNull
    public static Optional<HttpAuthHeaderFactory> createFactory(String jenkinsCredentialsId) {
        Optional<HttpAuthHeaderFactory> ret = Optional.empty();
        if (jenkinsCredentialsId != null && !jenkinsCredentialsId.isEmpty()) {
            ret = Optional.of(new HttpAuthHeaderFactory(jenkinsCredentialsId));
        }
        return ret;
    }

    @NonNull
    public static Optional<HttpAuthHeaderFactory> createFactory(@NonNull Optional<String> jenkinsCredentialsId) {
        Optional<HttpAuthHeaderFactory> ret = Optional.empty();
        if (jenkinsCredentialsId.isPresent() && !jenkinsCredentialsId.get().isEmpty()) {
            ret = HttpAuthHeaderFactory.createFactory(jenkinsCredentialsId.get());
        }
        return ret;
    }

    @NonNull
    public static Optional<HttpAuthHeaderFactory> createFactoryUsernamePassword(String username, String password) {
        Optional<HttpAuthHeaderFactory> ret = Optional.empty();
        if (username != null && !username.isEmpty() && password != null && !password.isEmpty()) {
            try {
                UsernamePasswordCredentialsImpl credentials = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, UUID.randomUUID().toString(), "temporarily created credentials", username, password);
                ret = Optional.of(new HttpAuthHeaderFactory((Credentials)credentials));
            }
            catch (Descriptor.FormException e) {
                throw new CredentialsNotFoundException("No Jenkins credentials set", e);
            }
        }
        return ret;
    }

    @NonNull
    public static Optional<HttpAuthHeaderFactory> createFactoryApikey(String apiKey) {
        Optional<HttpAuthHeaderFactory> ret = Optional.empty();
        if (apiKey != null && !apiKey.isEmpty()) {
            StringCredentialsImpl credentials = new StringCredentialsImpl(CredentialsScope.GLOBAL, UUID.randomUUID().toString(), "temporarily created credentials", Secret.fromString((String)apiKey));
            ret = Optional.of(new HttpAuthHeaderFactory((Credentials)credentials));
        }
        return ret;
    }

    @NonNull
    public static Optional<HttpAuthHeaderFactory> createFactoryBearer(String bearerToken) {
        Optional<HttpAuthHeaderFactory> ret = Optional.empty();
        if (bearerToken != null && !bearerToken.isEmpty()) {
            StringCredentialsImpl credentials = new StringCredentialsImpl(CredentialsScope.GLOBAL, UUID.randomUUID().toString(), "temporarily created credentials", Secret.fromString((String)bearerToken));
            ret = Optional.of(new HttpAuthHeaderFactory((Credentials)credentials, (Boolean)true));
        }
        return ret;
    }
}

