/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.init;

import hudson.Extension;
import hudson.util.ClassLoaderSanityThreadFactory;
import hudson.util.DaemonThreadFactory;
import hudson.util.NamingThreadFactory;
import io.jenkins.plugins.opentelemetry.api.OpenTelemetryLifecycleListener;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

@Extension
public class StepExecutionInstrumentationInitializer
implements OpenTelemetryLifecycleListener {
    static final Logger logger = Logger.getLogger(StepExecutionInstrumentationInitializer.class.getName());

    public void afterConfiguration(@Nonnull ConfigProperties configProperties) {
        try {
            logger.log(Level.FINE, () -> "Instrumenting " + SynchronousNonBlockingStepExecution.class.getName() + "...");
            Class<SynchronousNonBlockingStepExecution> synchronousNonBlockingStepExecutionClass = SynchronousNonBlockingStepExecution.class;
            Arrays.stream(synchronousNonBlockingStepExecutionClass.getDeclaredFields()).forEach(field -> logger.log(Level.FINE, () -> "Field: " + field.getName()));
            Field executorServiceField = synchronousNonBlockingStepExecutionClass.getDeclaredField("executorService");
            executorServiceField.setAccessible(true);
            ExecutorService executorService = (ExecutorService)Optional.ofNullable(executorServiceField.get(null)).orElseGet(() -> Executors.newCachedThreadPool((ThreadFactory)new NamingThreadFactory((ThreadFactory)new ClassLoaderSanityThreadFactory((ThreadFactory)new DaemonThreadFactory()), "org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution")));
            ExecutorService instrumentedExecutorService = Context.taskWrapping((ExecutorService)executorService);
            executorServiceField.set(null, instrumentedExecutorService);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

