/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.init;

import hudson.Extension;
import hudson.init.Terminator;
import hudson.util.PluginServletFilter;
import io.jenkins.plugins.opentelemetry.api.OpenTelemetryLifecycleListener;
import io.jenkins.plugins.opentelemetry.servlet.StaplerInstrumentationServletFilter;
import io.jenkins.plugins.opentelemetry.servlet.TraceContextServletFilter;
import jakarta.servlet.Filter;
import jakarta.servlet.ServletException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import jenkins.YesNoMaybe;

@Extension(dynamicLoadable=YesNoMaybe.MAYBE, optional=true)
public class ServletFilterInitializer
implements OpenTelemetryLifecycleListener {
    private static final Logger logger = Logger.getLogger(ServletFilterInitializer.class.getName());
    @Inject
    TraceContextServletFilter traceContextServletFilter;
    @Inject
    StaplerInstrumentationServletFilter staplerInstrumentationServletFilter;

    @PostConstruct
    public void postConstruct() {
        this.addToPluginServletFilter(this.traceContextServletFilter);
        this.addToPluginServletFilter(this.staplerInstrumentationServletFilter);
    }

    @Terminator
    @PreDestroy
    public void preDestroy() throws ServletException {
        PluginServletFilter.removeFilter((Filter)this.traceContextServletFilter);
        PluginServletFilter.removeFilter((Filter)this.staplerInstrumentationServletFilter);
    }

    private void addToPluginServletFilter(Filter filter) {
        if (PluginServletFilter.hasFilter((Filter)filter)) {
            logger.log(Level.INFO, () -> filter.getClass().getName() + " already enabled");
        } else {
            try {
                PluginServletFilter.addFilter((Filter)filter);
                logger.log(Level.FINE, () -> filter.getClass().getName() + " enabled");
            }
            catch (ServletException ex) {
                logger.log(Level.WARNING, "Failure to enable " + filter.getClass().getName(), ex);
            }
        }
    }
}

