/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.init;

import hudson.Extension;
import io.jenkins.plugins.opentelemetry.JenkinsControllerOpenTelemetry;
import io.jenkins.plugins.opentelemetry.api.OpenTelemetryLifecycleListener;
import io.opentelemetry.api.metrics.Meter;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import jenkins.YesNoMaybe;
import jenkins.scm.api.SCMEvent;

@Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
public class SCMEventMonitoringInitializer
implements OpenTelemetryLifecycleListener {
    private static final Logger logger = Logger.getLogger(SCMEventMonitoringInitializer.class.getName());
    @Inject
    protected JenkinsControllerOpenTelemetry jenkinsControllerOpenTelemetry;

    @PostConstruct
    public void postConstruct() {
        logger.log(Level.FINE, () -> "Start monitoring Jenkins controller SCM events...");
        Meter meter = Objects.requireNonNull(this.jenkinsControllerOpenTelemetry).getDefaultMeter();
        meter.counterBuilder("jenkins.scm.event.pool_size").setDescription("Number of threads handling SCM Events").setUnit("{events}").buildWithCallback(valueObserver -> valueObserver.record((long)SCMEvent.getEventProcessingMetrics().getPoolSize()));
        meter.upDownCounterBuilder("jenkins.scm.event.active_threads").setDescription("Number of threads actively handling SCM Events").setUnit("{threads}").buildWithCallback(valueObserver -> valueObserver.record((long)SCMEvent.getEventProcessingMetrics().getActiveThreads()));
        meter.upDownCounterBuilder("jenkins.scm.event.queued_tasks").setDescription("Number of queued SCM Event tasks").setUnit("{tasks}").buildWithCallback(valueObserver -> valueObserver.record((long)SCMEvent.getEventProcessingMetrics().getQueuedTasks()));
        meter.counterBuilder("jenkins.scm.event.completed_tasks").setDescription("Number of completed SCM Event tasks").setUnit("{tasks}").buildWithCallback(valueObserver -> valueObserver.record(SCMEvent.getEventProcessingMetrics().getCompletedTasks()));
    }
}

