/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.init;

import hudson.Extension;
import hudson.PluginManager;
import io.jenkins.plugins.opentelemetry.JenkinsControllerOpenTelemetry;
import io.jenkins.plugins.opentelemetry.api.OpenTelemetryLifecycleListener;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import jenkins.YesNoMaybe;
import jenkins.model.Jenkins;

@Extension(dynamicLoadable=YesNoMaybe.MAYBE, optional=true)
public class PluginMonitoringInitializer
implements OpenTelemetryLifecycleListener {
    private static final Logger logger = Logger.getLogger(PluginMonitoringInitializer.class.getName());
    @Inject
    JenkinsControllerOpenTelemetry jenkinsControllerOpenTelemetry;

    @PostConstruct
    public void postConstruct() {
        logger.log(Level.FINE, () -> "Start monitoring Jenkins plugins...");
        Meter meter = Objects.requireNonNull(this.jenkinsControllerOpenTelemetry).getDefaultMeter();
        ObservableLongMeasurement plugins = meter.gaugeBuilder("jenkins.plugins.count").setUnit("${plugins}").setDescription("Jenkins plugins").ofLongs().buildObserver();
        ObservableLongMeasurement pluginUpdates = meter.gaugeBuilder("jenkins.plugins.updates").setUnit("${plugins}").setDescription("Jenkins plugin updates").ofLongs().buildObserver();
        meter.batchCallback(() -> {
            logger.log(Level.FINE, () -> "Recording Jenkins controller executor pool metrics...");
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                logger.log(Level.FINE, () -> "Jenkins instance is null, skipping plugin monitoring metrics recording");
                return;
            }
            AtomicInteger active = new AtomicInteger();
            AtomicInteger inactive = new AtomicInteger();
            AtomicInteger hasUpdate = new AtomicInteger();
            AtomicInteger isUpToDate = new AtomicInteger();
            PluginManager pluginManager = jenkins.getPluginManager();
            pluginManager.getPlugins().forEach(plugin -> {
                if (plugin.isActive()) {
                    active.incrementAndGet();
                } else {
                    inactive.incrementAndGet();
                }
                if (plugin.hasUpdate()) {
                    hasUpdate.incrementAndGet();
                } else {
                    isUpToDate.incrementAndGet();
                }
            });
            int failed = pluginManager.getFailedPlugins().size();
            plugins.record((long)active.get(), Attributes.of(ExtendedJenkinsAttributes.STATUS, (Object)"active"));
            plugins.record((long)inactive.get(), Attributes.of(ExtendedJenkinsAttributes.STATUS, (Object)"inactive"));
            plugins.record((long)failed, Attributes.of(ExtendedJenkinsAttributes.STATUS, (Object)"failed"));
            pluginUpdates.record((long)hasUpdate.get(), Attributes.of(ExtendedJenkinsAttributes.STATUS, (Object)"hasUpdate"));
            pluginUpdates.record((long)isUpToDate.get(), Attributes.of(ExtendedJenkinsAttributes.STATUS, (Object)"isUpToDate"));
        }, (ObservableMeasurement)plugins, new ObservableMeasurement[]{pluginUpdates});
    }
}

