/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.init;

import hudson.Extension;
import hudson.init.Terminator;
import io.jenkins.plugins.opentelemetry.api.OpenTelemetryLifecycleListener;
import io.jenkins.plugins.opentelemetry.api.ReconfigurableOpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.context.Context;
import io.opentelemetry.semconv.ExceptionAttributes;
import io.opentelemetry.semconv.incubating.ThreadIncubatingAttributes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import jenkins.YesNoMaybe;

@Extension(dynamicLoadable=YesNoMaybe.YES, optional=true, ordinal=2.147483637E9)
public class OtelJulHandler
extends Handler
implements OpenTelemetryLifecycleListener {
    private static final Logger logger = Logger.getLogger(OtelJulHandler.class.getName());
    private static final Formatter FORMATTER = new AccessibleFormatter();
    private boolean captureExperimentalAttributes;
    private LoggerProvider loggerProvider;
    @Inject
    protected ReconfigurableOpenTelemetry openTelemetry;
    private boolean disabled = false;

    public OtelJulHandler() {
        try {
            Context context = Context.current();
            logger.log(Level.FINER, () -> "OtelJulHandler initialization - context: " + String.valueOf(context));
        }
        catch (NoClassDefFoundError | RuntimeException e) {
            logger.log(Level.WARNING, "Exception initializing OPenTelemetry SDK logging apis, disable OtelJulHandler");
            throw e;
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (this.disabled) {
            return;
        }
        try {
            String instrumentationName = logRecord.getLoggerName();
            if (instrumentationName == null || instrumentationName.isEmpty()) {
                instrumentationName = "ROOT";
            }
            LogRecordBuilder logBuilder = this.loggerProvider.get(instrumentationName).logRecordBuilder();
            String message = FORMATTER.formatMessage(logRecord);
            if (message != null) {
                logBuilder = logBuilder.setBody(message);
            }
            Instant timestamp = logRecord.getInstant();
            logBuilder = logBuilder.setTimestamp(timestamp);
            Level level = logRecord.getLevel();
            if (level != null) {
                logBuilder = logBuilder.setSeverity(OtelJulHandler.levelToSeverity(level)).setSeverityText(logRecord.getLevel().getName());
            }
            AttributesBuilder attributes = Attributes.builder();
            Throwable throwable = logRecord.getThrown();
            if (throwable != null) {
                attributes.put(ExceptionAttributes.EXCEPTION_TYPE, (Object)throwable.getClass().getName());
                attributes.put(ExceptionAttributes.EXCEPTION_MESSAGE, (Object)throwable.getMessage());
                StringWriter writer = new StringWriter();
                throwable.printStackTrace(new PrintWriter(writer));
                attributes.put(ExceptionAttributes.EXCEPTION_STACKTRACE, (Object)writer.toString());
            }
            if (this.captureExperimentalAttributes) {
                Thread currentThread = Thread.currentThread();
                attributes.put(ThreadIncubatingAttributes.THREAD_NAME, (Object)currentThread.getName());
                attributes.put(ThreadIncubatingAttributes.THREAD_ID, (Object)currentThread.getId());
            } else {
                attributes.put(ThreadIncubatingAttributes.THREAD_ID, (Object)logRecord.getLongThreadID());
            }
            logBuilder = logBuilder.setAllAttributes(attributes.build()).setContext(Context.current());
            logBuilder.emit();
        }
        catch (RuntimeException e) {
            System.err.println("Exception sending logs to OTLP endpoint, disable OTelJulHandler");
            e.printStackTrace();
            this.disabled = true;
        }
    }

    private static Severity levelToSeverity(Level level) {
        int lev = level.intValue();
        if (lev <= Level.FINEST.intValue()) {
            return Severity.TRACE;
        }
        if (lev <= Level.FINER.intValue()) {
            return Severity.DEBUG;
        }
        if (lev <= Level.FINE.intValue()) {
            return Severity.DEBUG2;
        }
        if (lev <= Level.CONFIG.intValue()) {
            return Severity.DEBUG3;
        }
        if (lev <= Level.INFO.intValue()) {
            return Severity.INFO;
        }
        if (lev <= Level.WARNING.intValue()) {
            return Severity.WARN;
        }
        if (lev <= Level.SEVERE.intValue()) {
            return Severity.ERROR;
        }
        return Severity.FATAL;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    @PostConstruct
    public void postConstruct() {
        this.loggerProvider = this.openTelemetry.getLogsBridge();
        this.captureExperimentalAttributes = this.openTelemetry.getConfig().getBoolean("otel.instrumentation.java-util-logging.experimental-log-attributes", false);
        Logger.getLogger("").addHandler(this);
        logger.log(Level.INFO, "OTel logging Handler registered on java.util.logging");
    }

    @Terminator
    @PreDestroy
    public void preDestroy() {
        Logger.getLogger("").removeHandler(this);
        logger.log(Level.INFO, "OTel logging Handler unregistered from java.util.logging");
    }

    public int ordinal() {
        return Integer.MIN_VALUE;
    }

    private static class AccessibleFormatter
    extends Formatter {
        private AccessibleFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            throw new UnsupportedOperationException();
        }
    }
}

