/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.init;

import hudson.Extension;
import io.jenkins.plugins.opentelemetry.api.OpenTelemetryLifecycleListener;
import io.jenkins.plugins.opentelemetry.api.ReconfigurableOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Classes;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Cpu;
import io.opentelemetry.instrumentation.runtimemetrics.java8.GarbageCollector;
import io.opentelemetry.instrumentation.runtimemetrics.java8.MemoryPools;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Threads;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.ExperimentalBufferPools;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.ExperimentalCpu;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.ExperimentalMemoryPools;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import jenkins.YesNoMaybe;

@Extension(dynamicLoadable=YesNoMaybe.MAYBE, optional=true)
public class JvmMonitoringInitializer
implements OpenTelemetryLifecycleListener {
    private static final Logger LOGGER = Logger.getLogger(JvmMonitoringInitializer.class.getName());
    @Inject
    protected ReconfigurableOpenTelemetry openTelemetry;

    @PostConstruct
    public void postConstruct() {
        boolean defaultEnabled;
        ConfigProperties config = this.openTelemetry.getConfig();
        if (!config.getBoolean("otel.instrumentation.runtime-metrics.enabled", defaultEnabled = config.getBoolean("otel.instrumentation.common.default-enabled", true))) {
            LOGGER.log(Level.FINE, "Jenkins Controller JVM is disabled by config and reconfiguration requires restart ...");
            return;
        }
        LOGGER.log(Level.FINE, "Start monitoring Jenkins Controller JVM...");
        ExperimentalBufferPools.registerObservers((OpenTelemetry)this.openTelemetry);
        ExperimentalCpu.registerObservers((OpenTelemetry)this.openTelemetry);
        ExperimentalMemoryPools.registerObservers((OpenTelemetry)this.openTelemetry);
        Classes.registerObservers((OpenTelemetry)this.openTelemetry);
        Cpu.registerObservers((OpenTelemetry)this.openTelemetry);
        GarbageCollector.registerObservers((OpenTelemetry)this.openTelemetry);
        MemoryPools.registerObservers((OpenTelemetry)this.openTelemetry);
        Threads.registerObservers((OpenTelemetry)this.openTelemetry);
    }
}

