/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.computer;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.slaves.ComputerListener;
import io.jenkins.plugins.opentelemetry.JenkinsControllerOpenTelemetry;
import io.jenkins.plugins.opentelemetry.OpenTelemetryAttributesAction;
import io.jenkins.plugins.opentelemetry.api.OpenTelemetryLifecycleListener;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.semconv.incubating.HostIncubatingAttributes;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import jenkins.YesNoMaybe;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;

@Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
public class MonitoringComputerListener
extends ComputerListener
implements OpenTelemetryLifecycleListener {
    private static final Logger LOGGER = Logger.getLogger(MonitoringComputerListener.class.getName());
    private LongCounter failureAgentCounter;
    @Inject
    protected JenkinsControllerOpenTelemetry jenkinsControllerOpenTelemetry;

    @PostConstruct
    public void postConstruct() {
        Meter meter = this.jenkinsControllerOpenTelemetry.getDefaultMeter();
        Jenkins jenkins = Jenkins.get();
        Computer controllerComputer = jenkins.getComputer("");
        if (controllerComputer == null) {
            LOGGER.log(Level.FINE, () -> "IllegalState Jenkins Controller computer not found");
        } else if (controllerComputer.getAction(OpenTelemetryAttributesAction.class) != null) {
            LOGGER.log(Level.FINER, () -> "Resources for Jenkins Controller computer " + String.valueOf(controllerComputer) + " have already been defined: " + String.valueOf(controllerComputer.getAction(OpenTelemetryAttributesAction.class)));
        } else {
            try {
                OpenTelemetryAttributesAction openTelemetryAttributesAction = new OpenTelemetryAttributesAction();
                Object attributesAsMap = new GetComputerAttributes().call();
                for (Map.Entry attribute : attributesAsMap.entrySet()) {
                    openTelemetryAttributesAction.getAttributes().put(AttributeKey.stringKey((String)((String)attribute.getKey())), attribute.getValue());
                }
                openTelemetryAttributesAction.getAttributes().put(AttributeKey.stringKey((String)ExtendedJenkinsAttributes.JENKINS_COMPUTER_NAME.getKey()), "#controller#");
                LOGGER.log(Level.FINER, () -> "Resources for Jenkins Controller computer " + String.valueOf(controllerComputer) + ": " + String.valueOf(openTelemetryAttributesAction));
                controllerComputer.addAction((Action)openTelemetryAttributesAction);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failure getting attributes for Jenkins Controller computer " + String.valueOf(controllerComputer), e);
            }
        }
        meter.gaugeBuilder("jenkins.agents.offline").ofLongs().setDescription("Number of offline agents").setUnit("{agents}").buildWithCallback(valueObserver -> valueObserver.record(this.getOfflineAgentsCount()));
        meter.gaugeBuilder("jenkins.agents.online").ofLongs().setDescription("Number of online agents").setUnit("{agents}").buildWithCallback(valueObserver -> valueObserver.record(this.getOnlineAgentsCount()));
        meter.gaugeBuilder("jenkins.agents.total").ofLongs().setDescription("Number of agents").setUnit("{agents}").buildWithCallback(valueObserver -> valueObserver.record(this.getAgentsCount()));
        this.failureAgentCounter = meter.counterBuilder("jenkins.agents.launch.failure").setDescription("Number of ComputerLauncher failures").setUnit("{agents}").build();
        LOGGER.log(Level.FINE, () -> "Start monitoring Jenkins agents management...");
    }

    private long getOfflineAgentsCount() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return 0L;
        }
        return Arrays.stream(jenkins.getComputers()).filter(Computer::isOffline).count();
    }

    private long getOnlineAgentsCount() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return 0L;
        }
        return Arrays.stream(jenkins.getComputers()).filter(Computer::isOnline).count();
    }

    private long getAgentsCount() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return 0L;
        }
        return Arrays.stream(jenkins.getComputers()).count();
    }

    public void preOnline(Computer computer, Channel channel, FilePath root, TaskListener listener) throws IOException, InterruptedException {
        OpenTelemetryAttributesAction openTelemetryAttributesAction = new OpenTelemetryAttributesAction();
        Map attributes = (Map)channel.call((Callable)new GetComputerAttributes());
        for (Map.Entry attribute : attributes.entrySet()) {
            openTelemetryAttributesAction.getAttributes().put(AttributeKey.stringKey((String)((String)attribute.getKey())), attribute.getValue());
        }
        openTelemetryAttributesAction.getAttributes().put(AttributeKey.stringKey((String)ExtendedJenkinsAttributes.JENKINS_COMPUTER_NAME.getKey()), computer.getName());
        LOGGER.log(Level.FINE, () -> "preOnline(" + String.valueOf(computer) + "): " + String.valueOf(openTelemetryAttributesAction));
        computer.addAction((Action)openTelemetryAttributesAction);
    }

    public void onLaunchFailure(Computer computer, TaskListener taskListener) {
        this.failureAgentCounter.add(1L);
        LOGGER.log(Level.FINE, () -> "onLaunchFailure(" + String.valueOf(computer) + "): ");
    }

    private static class GetComputerAttributes
    extends MasterToSlaveCallable<Map<String, String>, IOException> {
        private GetComputerAttributes() {
        }

        public Map<String, String> call() throws IOException {
            HashMap<String, String> attributes;
            block4: {
                attributes = new HashMap<String, String>();
                try {
                    InetAddress localHost = InetAddress.getLocalHost();
                    if (localHost.isLoopbackAddress()) {
                        // empty if block
                    }
                    attributes.put(HostIncubatingAttributes.HOST_NAME.getKey(), localHost.getHostName());
                    attributes.put(HostIncubatingAttributes.HOST_IP.getKey(), localHost.getHostAddress());
                }
                catch (IOException e) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "Exception retrieving the build agent host details", e);
                    }
                    if (!LOGGER.isLoggable(Level.FINE)) break block4;
                    LOGGER.log(Level.FINE, () -> "Exception retrieving the build agent host details " + e.getMessage());
                }
            }
            return attributes;
        }
    }
}

