/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.computer;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Node;
import hudson.slaves.CloudProvisioningListener;
import hudson.slaves.NodeProvisioner;
import io.jenkins.plugins.opentelemetry.JenkinsControllerOpenTelemetry;
import io.jenkins.plugins.opentelemetry.api.OpenTelemetryLifecycleListener;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import jenkins.YesNoMaybe;

@Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
public class MonitoringCloudListener
extends CloudProvisioningListener
implements OpenTelemetryLifecycleListener {
    private static final Logger LOGGER = Logger.getLogger(MonitoringCloudListener.class.getName());
    private LongCounter failureCloudCounter;
    private LongCounter totalCloudCount;
    @Inject
    private JenkinsControllerOpenTelemetry jenkinsControllerOpenTelemetry;

    @PostConstruct
    public void postConstruct() {
        Meter meter = this.jenkinsControllerOpenTelemetry.getDefaultMeter();
        LOGGER.log(Level.FINE, () -> "Start monitoring Jenkins controller cloud agent provisioning...");
        this.failureCloudCounter = meter.counterBuilder("jenkins.cloud.agents.failure").setDescription("Number of failed cloud agents when provisioning").setUnit("{agents}").build();
        this.totalCloudCount = meter.counterBuilder("jenkins.cloud.agents.completed").setDescription("Number of provisioned cloud agents").setUnit("{agents}").build();
    }

    public void onFailure(NodeProvisioner.PlannedNode plannedNode, Throwable t) {
        this.failureCloudCounter.add(1L);
        LOGGER.log(Level.FINE, () -> "onFailure(" + String.valueOf(plannedNode) + ")");
    }

    public void onRollback(@NonNull NodeProvisioner.PlannedNode plannedNode, @NonNull Node node, @NonNull Throwable t) {
        this.failureCloudCounter.add(1L);
        LOGGER.log(Level.FINE, () -> "onRollback(" + String.valueOf(plannedNode) + ")");
    }

    public void onComplete(NodeProvisioner.PlannedNode plannedNode, Node node) {
        this.totalCloudCount.add(1L);
        LOGGER.log(Level.FINE, () -> "onComplete(" + String.valueOf(plannedNode) + ")");
    }
}

