/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend.elastic;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch.ilm.Actions;
import co.elastic.clients.elasticsearch.ilm.Phase;
import co.elastic.clients.elasticsearch.indices.ElasticsearchIndicesClient;
import co.elastic.clients.elasticsearch.indices.GetIndexResponse;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest5_client.Rest5ClientTransport;
import co.elastic.clients.transport.rest5_client.low_level.Rest5Client;
import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import groovy.text.Template;
import hudson.util.FormValidation;
import io.jenkins.plugins.opentelemetry.JenkinsControllerOpenTelemetry;
import io.jenkins.plugins.opentelemetry.TemplateBindingsProvider;
import io.jenkins.plugins.opentelemetry.backend.elastic.ElasticsearchBuildLogsLineIterator;
import io.jenkins.plugins.opentelemetry.jenkins.HttpAuthHeaderFactory;
import io.jenkins.plugins.opentelemetry.job.log.LogStorageRetriever;
import io.jenkins.plugins.opentelemetry.job.log.LogsQueryResult;
import io.jenkins.plugins.opentelemetry.job.log.LogsViewHeader;
import io.jenkins.plugins.opentelemetry.job.log.util.InputStreamByteBuffer;
import io.jenkins.plugins.opentelemetry.job.log.util.LogLineIterator;
import io.jenkins.plugins.opentelemetry.job.log.util.LogLineIteratorInputStream;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.TimeValue;

public class ElasticsearchLogStorageRetriever
implements LogStorageRetriever,
Closeable {
    private static final Logger logger = Logger.getLogger(ElasticsearchLogStorageRetriever.class.getName());
    public static final String KEEPALIVE_INTERVAL_DEFAULT = "30000";
    public static final String KEEPALIVE_DEFAULT = "true";
    public static final String KEEPALIVE_INTERVAL_PROPERTY = ElasticsearchLogStorageRetriever.class.getName() + ".keepAlive.interval";
    public static final String KEEPALIVE_PROPERTY = ElasticsearchLogStorageRetriever.class.getName() + ".keepAlive.enabled";
    public static final int KEEPALIVE_INTERVAL = Integer.parseInt(System.getProperty(KEEPALIVE_INTERVAL_PROPERTY, "30000"));
    public static final boolean KEEPALIVE = Boolean.parseBoolean(System.getProperty(KEEPALIVE_PROPERTY, "true"));
    @NonNull
    private final Template buildLogsVisualizationUrlTemplate;
    private final TemplateBindingsProvider templateBindingsProvider;
    @NonNull
    final String elasticsearchCredentialsId;
    @NonNull
    final String elasticsearchUrl;
    @NonNull
    final Rest5Client restClient;
    @NonNull
    final Rest5ClientTransport elasticsearchTransport;
    @NonNull
    private final ElasticsearchClient esClient;
    private Tracer _tracer;

    @MustBeClosed
    public ElasticsearchLogStorageRetriever(@NonNull String elasticsearchUrl, boolean disableSslVerifications, @NonNull String elasticsearchCredentialsId, @NonNull Template buildLogsVisualizationUrlTemplate, @NonNull TemplateBindingsProvider templateBindingsProvider) {
        if (StringUtils.isBlank((String)elasticsearchUrl)) {
            throw new IllegalArgumentException("Elasticsearch url cannot be blank");
        }
        this.elasticsearchUrl = elasticsearchUrl;
        this.elasticsearchCredentialsId = elasticsearchCredentialsId;
        RequestConfig requestConfig = RequestConfig.custom().setConnectionKeepAlive(TimeValue.ofMilliseconds((long)KEEPALIVE_INTERVAL)).build();
        CloseableHttpAsyncClient httpclient = HttpAsyncClients.custom().setDefaultRequestConfig(requestConfig).build();
        if (disableSslVerifications) {
            SSLContext sslContext;
            try {
                sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy()).build();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new IllegalArgumentException(e);
            }
            TlsStrategy tlsStrategy = ClientTlsStrategyBuilder.create().setSslContext(sslContext).setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
            PoolingAsyncClientConnectionManager cm = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(tlsStrategy).build();
            httpclient = HttpAsyncClients.custom().setDefaultRequestConfig(requestConfig).setConnectionManager((AsyncClientConnectionManager)cm).build();
        }
        HttpAuthHeaderFactory httpAuthHeaderFactory = new HttpAuthHeaderFactory(elasticsearchCredentialsId);
        Header[] headers = new Header[]{httpAuthHeaderFactory.createAuthHeader()};
        this.restClient = Rest5Client.builder((URI[])new URI[]{URI.create(elasticsearchUrl)}).setHttpClient(httpclient).setDefaultHeaders(headers).build();
        this.elasticsearchTransport = new Rest5ClientTransport(this.restClient, (JsonpMapper)new JacksonJsonpMapper());
        this.esClient = new ElasticsearchClient((ElasticsearchTransport)this.elasticsearchTransport);
        this.buildLogsVisualizationUrlTemplate = buildLogsVisualizationUrlTemplate;
        this.templateBindingsProvider = templateBindingsProvider;
    }

    @Override
    @NonNull
    public LogsQueryResult overallLog(@NonNull String jobFullName, int runNumber, @NonNull String traceId, @NonNull String spanId, boolean complete, @NonNull Instant startTime, Instant endTime) {
        Charset charset = StandardCharsets.UTF_8;
        SpanBuilder spanBuilder = this.getTracer().spanBuilder("ElasticsearchLogStorageRetriever.overallLog").setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_ID, (Object)jobFullName).setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_NUMBER, (Object)runNumber).setAttribute("complete", complete);
        Span span = spanBuilder.startSpan();
        try {
            LogsQueryResult logsQueryResult;
            block9: {
                Scope scope = span.makeCurrent();
                try {
                    ElasticsearchBuildLogsLineIterator logLines = new ElasticsearchBuildLogsLineIterator(jobFullName, runNumber, traceId, this.esClient, this.getTracer());
                    LogLineIterator.JenkinsHttpSessionLineBytesToLogLineIdMapper lineBytesToLineNumberConverter = new LogLineIterator.JenkinsHttpSessionLineBytesToLogLineIdMapper(jobFullName, runNumber, null);
                    LogLineIteratorInputStream<Long> lineIteratorInputStream = new LogLineIteratorInputStream<Long>(logLines, lineBytesToLineNumberConverter, this.getTracer());
                    InputStreamByteBuffer byteBuffer = new InputStreamByteBuffer(lineIteratorInputStream, this.getTracer());
                    Map<String, Object> localBindings = Map.of("traceId", traceId, "spanId", spanId);
                    Map<String, Object> bindings = TemplateBindingsProvider.compose(this.templateBindingsProvider, localBindings).getBindings();
                    String logsVisualizationUrl = this.buildLogsVisualizationUrlTemplate.make(bindings).toString();
                    logsQueryResult = new LogsQueryResult(byteBuffer, new LogsViewHeader(bindings.get("backendName").toString(), logsVisualizationUrl, bindings.get("backend24x24IconUrl").toString()), charset, complete);
                    if (scope == null) break block9;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                scope.close();
            }
            return logsQueryResult;
        }
        finally {
            span.end();
        }
    }

    @Override
    @NonNull
    public LogsQueryResult stepLog(@NonNull String jobFullName, int runNumber, @NonNull String flowNodeId, @NonNull String traceId, @NonNull String spanId, boolean complete, @NonNull Instant startTime, @Nullable Instant endTime) {
        Charset charset = StandardCharsets.UTF_8;
        SpanBuilder spanBuilder = this.getTracer().spanBuilder("ElasticsearchLogStorageRetriever.stepLog").setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_ID, (Object)jobFullName).setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_NUMBER, (Object)runNumber).setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_ID, (Object)flowNodeId).setAttribute("complete", complete);
        Span span = spanBuilder.startSpan();
        try {
            LogsQueryResult logsQueryResult;
            block9: {
                Scope scope = span.makeCurrent();
                try {
                    ElasticsearchBuildLogsLineIterator logLines = new ElasticsearchBuildLogsLineIterator(jobFullName, runNumber, traceId, flowNodeId, this.esClient, this.getTracer());
                    LogLineIterator.JenkinsHttpSessionLineBytesToLogLineIdMapper logLineBytesToLogLineIdMapper = new LogLineIterator.JenkinsHttpSessionLineBytesToLogLineIdMapper(jobFullName, runNumber, flowNodeId);
                    LogLineIteratorInputStream<Long> logLineIteratorInputStream = new LogLineIteratorInputStream<Long>(logLines, logLineBytesToLogLineIdMapper, this.getTracer());
                    InputStreamByteBuffer byteBuffer = new InputStreamByteBuffer(logLineIteratorInputStream, this.getTracer());
                    HashMap<String, Object> localBindings = new HashMap<String, Object>();
                    localBindings.put("traceId", traceId);
                    localBindings.put("spanId", spanId);
                    Map<String, Object> bindings = TemplateBindingsProvider.compose(this.templateBindingsProvider, localBindings).getBindings();
                    String logsVisualizationUrl = this.buildLogsVisualizationUrlTemplate.make(bindings).toString();
                    logsQueryResult = new LogsQueryResult(byteBuffer, new LogsViewHeader(bindings.get("backendName").toString(), logsVisualizationUrl, bindings.get("backend24x24IconUrl").toString()), charset, complete);
                    if (scope == null) break block9;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                scope.close();
            }
            return logsQueryResult;
        }
        finally {
            span.end();
        }
    }

    public List<FormValidation> checkElasticsearchSetup() {
        ArrayList<FormValidation> validations = new ArrayList<FormValidation>();
        ElasticsearchIndicesClient indicesClient = this.esClient.indices();
        try {
            GetIndexResponse response = indicesClient.get(b -> b.index("logs-*", new String[0]));
            if (response == null || response.indices() == null || response.indices().isEmpty()) {
                validations.add(FormValidation.warning((String)"Index Template 'logs-*' NOT found."));
            } else {
                validations.add(FormValidation.ok((String)"Indices 'logs-*' found."));
            }
        }
        catch (ElasticsearchException e) {
            logger.fine(e.getLocalizedMessage());
            validations.addAll(this.findEsErrorCause(e));
            return validations;
        }
        catch (IOException e) {
            logger.fine(e.getLocalizedMessage());
            validations.add(FormValidation.warning((String)("Exception accessing Elasticsearch " + this.elasticsearchUrl + " with credentials '" + this.elasticsearchCredentialsId + "'."), (Object[])new Object[]{e}));
            return validations;
        }
        validations.add(FormValidation.ok((String)("Connected to Elasticsearch " + this.elasticsearchUrl + " with credentials '" + this.elasticsearchCredentialsId + "'.")));
        return validations;
    }

    @NonNull
    private List<FormValidation> findEsErrorCause(@NonNull ElasticsearchException e) {
        ArrayList<FormValidation> validations = new ArrayList<FormValidation>();
        ErrorCause errorCause = e.error();
        int status = e.status();
        if ("security_exception".equals(errorCause.type())) {
            if (status == 401) {
                validations.add(FormValidation.error((String)("Authentication failure /" + status + " accessing Elasticsearch " + this.elasticsearchUrl + " with user '" + this.elasticsearchCredentialsId + "'."), (Object[])new Object[]{e}));
            } else if (status == 403) {
                validations.add(FormValidation.ok((String)("Connected to Elasticsearch " + this.elasticsearchUrl + " with credentials '" + this.elasticsearchCredentialsId + "'.")));
                validations.add(FormValidation.warning((String)(errorCause.type() + "/" + status + " accessing index template 'logs-*' on '" + this.elasticsearchUrl + "'. Elasticsearch credentials '" + this.elasticsearchCredentialsId + "' doesn't have read permission to the index template metadata - " + errorCause.reason() + ".")));
            } else {
                validations.add(FormValidation.ok((String)("Connected to Elasticsearch " + this.elasticsearchUrl + " with credentials '" + this.elasticsearchCredentialsId + "'.")));
                validations.add(FormValidation.warning((String)(errorCause.type() + "/" + status + " accessing index template 'logs-*' on '" + this.elasticsearchUrl + "' with Elasticsearch credentials '" + this.elasticsearchCredentialsId + "' - " + errorCause.reason() + ".")));
            }
        } else {
            validations.add(FormValidation.warning((String)(errorCause.type() + "/" + status + " accessing index template 'logs-*' on '" + this.elasticsearchUrl + "' with Elasticsearch credentials '" + this.elasticsearchCredentialsId + "' - " + errorCause.reason() + ".")));
        }
        return validations;
    }

    @NonNull
    protected static String prettyPrintPhaseRetentionPolicy(Phase phase, String phaseName) {
        if (phase == null) {
            return phaseName + " [phase not defined]";
        }
        String retentionPolicySpec = "no actions";
        Actions actions = phase.actions();
        if (actions != null) {
            retentionPolicySpec = actions.toString();
        }
        return phaseName + "[" + retentionPolicySpec + "]";
    }

    @Override
    public void close() throws IOException {
        logger.log(Level.FINE, () -> "Shutdown Elasticsearch client...");
        this.elasticsearchTransport.close();
        this.restClient.close();
    }

    public String toString() {
        return "ElasticsearchLogStorageRetriever{elasticsearchUrl=" + this.elasticsearchUrl + "}";
    }

    private Tracer getTracer() {
        if (this._tracer == null) {
            this._tracer = JenkinsControllerOpenTelemetry.get().getDefaultTracer();
        }
        return this._tracer;
    }
}

