/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend.elastic;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jenkins.plugins.opentelemetry.backend.ElasticBackend;
import io.jenkins.plugins.opentelemetry.job.log.ConsoleNotes;
import io.jenkins.plugins.opentelemetry.job.log.LogLine;
import io.jenkins.plugins.opentelemetry.job.log.util.LogLineIterator;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.Scope;
import java.io.Closeable;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONArray;

public class ElasticsearchBuildLogsLineIterator
implements LogLineIterator<Long>,
Closeable {
    private static final Logger logger = Logger.getLogger(ElasticsearchBuildLogsLineIterator.class.getName());
    public static final Time POINT_IN_TIME_KEEP_ALIVE = Time.of(builder -> builder.time("30s"));
    public static final int PAGE_SIZE = 200;
    public static final int MAX_LINES_PAGINATED = 10000;
    final String jobFullName;
    final int runNumber;
    long lineNumber;
    @Nullable
    final String flowNodeId;
    final String traceId;
    final ElasticsearchClient esClient;
    final Tracer tracer;
    String pointInTimeId;
    boolean enableEDOT;
    @VisibleForTesting
    int queryCounter;
    Iterator<LogLine<Long>> delegate;
    boolean endOfStream;

    public ElasticsearchBuildLogsLineIterator(@NonNull String jobFullName, int runNumber, @NonNull String traceId, @NonNull ElasticsearchClient esClient, @NonNull Tracer tracer) {
        this(jobFullName, runNumber, traceId, null, esClient, tracer);
        this.setEDOTMode();
    }

    public ElasticsearchBuildLogsLineIterator(@NonNull String jobFullName, int runNumber, @NonNull String traceId, @Nullable String flowNodeId, @NonNull ElasticsearchClient esClient, @NonNull Tracer tracer) {
        this.tracer = tracer;
        this.jobFullName = jobFullName;
        this.runNumber = runNumber;
        this.traceId = traceId;
        this.flowNodeId = flowNodeId;
        this.esClient = esClient;
        this.setEDOTMode();
    }

    private void setEDOTMode() {
        this.enableEDOT = ElasticBackend.get().isPresent() ? ElasticBackend.get().get().isEnableEDOT() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String lazyLoadPointInTimeId() throws IOException {
        if (this.pointInTimeId == null) {
            Span esOpenPitSpan = this.tracer.spanBuilder("ElasticsearchLogsSearchIterator.openPointInTime").setAttribute("query.index", "logs-*").setAttribute("query.keepAlive", POINT_IN_TIME_KEEP_ALIVE.time()).startSpan();
            try (Scope ignored = esOpenPitSpan.makeCurrent();){
                this.pointInTimeId = this.esClient.openPointInTime(pit -> pit.index("logs-*", new String[0]).keepAlive(POINT_IN_TIME_KEEP_ALIVE)).id();
                esOpenPitSpan.setAttribute("pitId", this.pointInTimeId);
            }
            finally {
                esOpenPitSpan.end();
            }
        }
        return this.pointInTimeId;
    }

    @NonNull
    Iterator<LogLine<Long>> getCurrentIterator() {
        try {
            if (this.endOfStream) {
                return this.delegate;
            }
            if (this.delegate == null) {
                this.delegate = this.loadNextFormattedLogLines();
            }
            if (this.delegate.hasNext()) {
                return this.delegate;
            }
            this.delegate = this.loadNextFormattedLogLines();
            if (!this.delegate.hasNext()) {
                this.endOfStream = true;
            }
            return this.delegate;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block19: {
            Tracer tracer = logger.isLoggable(Level.FINE) ? this.tracer : TracerProvider.noop().get("noop");
            SpanBuilder spanBuilder = tracer.spanBuilder("ElasticsearchBuildLogsLineIterator.close").setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_ID, (Object)this.jobFullName).setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_NUMBER, (Object)this.runNumber).setAttribute("pointInTimeId", this.pointInTimeId);
            if (this.flowNodeId != null) {
                spanBuilder.setAttribute(ExtendedJenkinsAttributes.JENKINS_STEP_ID, (Object)this.flowNodeId);
            }
            Span closeSpan = spanBuilder.startSpan();
            try (Scope ignored = closeSpan.makeCurrent();){
                if (this.pointInTimeId == null) break block19;
                Span esClosePitSpan = this.tracer.spanBuilder("Elasticsearch.closePointInTime").setAttribute("query.pointInTimeId", this.pointInTimeId).startSpan();
                try (Scope ignored2 = esClosePitSpan.makeCurrent();){
                    this.esClient.closePointInTime(builder -> builder.id(this.pointInTimeId));
                }
                finally {
                    esClosePitSpan.end();
                    this.pointInTimeId = null;
                }
            }
            finally {
                closeSpan.end();
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.getCurrentIterator().hasNext();
    }

    @Override
    public LogLine<Long> next() {
        return this.getCurrentIterator().next();
    }

    protected Iterator<LogLine<Long>> loadNextFormattedLogLines() throws IOException {
        if (this.queryCounter == Integer.MAX_VALUE) {
            logger.log(Level.INFO, () -> "Skip more than Integer.MAX_VALUE pages, return empty result");
            return Collections.emptyIterator();
        }
        if (this.lineNumber > 10000L) {
            logger.log(Level.INFO, () -> "Skip more than 10000 pages, return empty result");
            return Collections.emptyIterator();
        }
        String loadPointInTimeId = this.lazyLoadPointInTimeId();
        Span esSearchSpan = this.tracer.spanBuilder("ElasticsearchLogsSearchIterator.search").startSpan();
        try {
            Iterator<LogLine<Long>> iterator;
            block14: {
                Scope ignoredEsSearchSpanScope = esSearchSpan.makeCurrent();
                try {
                    esSearchSpan.setAttribute("query.pointInTimeId", this.lazyLoadPointInTimeId()).setAttribute("query.from", (long)this.queryCounter).setAttribute("query.size", 200L).setAttribute("query.match.traceId", this.traceId).setAttribute("query.match.jobFullName", this.jobFullName).setAttribute("query.match.runNumber", (long)this.runNumber);
                    Query query = this.getQuery(esSearchSpan);
                    SearchRequest searchRequest = new SearchRequest.Builder().pit(pit -> pit.id(loadPointInTimeId).keepAlive(POINT_IN_TIME_KEEP_ALIVE)).from(Integer.valueOf((int)this.lineNumber)).size(Integer.valueOf(200)).sort(s -> s.field(f -> f.field("@timestamp").order(SortOrder.Asc))).query(query).build();
                    SearchResponse searchResponse = this.esClient.search(searchRequest, ObjectNode.class);
                    List hits = searchResponse.hits().hits();
                    esSearchSpan.setAttribute("response.size", (long)hits.size());
                    this.lineNumber += (long)hits.size();
                    if (hits.size() == 0) {
                        this.endOfStream = true;
                    }
                    iterator = hits.stream().map(new ElasticsearchHitToFormattedLogLine(this.getAttributesField())).filter(Objects::nonNull).iterator();
                    if (ignoredEsSearchSpanScope == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignoredEsSearchSpanScope != null) {
                            try {
                                ignoredEsSearchSpanScope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ElasticsearchException e) {
                        esSearchSpan.recordException((Throwable)e);
                        throw e;
                    }
                }
                ignoredEsSearchSpanScope.close();
            }
            return iterator;
        }
        finally {
            esSearchSpan.end();
            ++this.queryCounter;
        }
    }

    private String getAttributesField() {
        return this.enableEDOT ? "attributes" : "labels";
    }

    private Query getQuery(Span esSearchSpan) {
        String fieldTraceID = "trace.id";
        String fieldJobFullName = ExtendedJenkinsAttributes.CI_PIPELINE_ID.getKey();
        String fieldRunNumber = ExtendedJenkinsAttributes.CI_PIPELINE_RUN_NUMBER.getKey();
        String fieldFlowNodeId = ExtendedJenkinsAttributes.JENKINS_STEP_ID.getKey();
        if (!this.enableEDOT) {
            fieldJobFullName = "labels.ci_pipeline_id";
            fieldRunNumber = "numeric_labels.ci_pipeline_run_number";
            fieldFlowNodeId = "labels.jenkins_pipeline_step_id";
        }
        BoolQuery.Builder queryBuilder = QueryBuilders.bool().must(QueryBuilders.match().field(fieldTraceID).query(FieldValue.of((String)this.traceId)).build()._toQuery(), new Query[]{QueryBuilders.match().field(fieldJobFullName).query(FieldValue.of((String)this.jobFullName)).build()._toQuery(), QueryBuilders.match().field(fieldRunNumber).query(FieldValue.of((long)this.runNumber)).build()._toQuery()});
        if (this.flowNodeId != null) {
            esSearchSpan.setAttribute("query.match.flowNodeId", this.flowNodeId);
            queryBuilder.must(QueryBuilders.match().field(fieldFlowNodeId).query(FieldValue.of((String)this.flowNodeId)).build()._toQuery(), new Query[0]);
        }
        Query query = queryBuilder.build()._toQuery();
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void skipLines(Long skipLines) {
        Tracer tracer = logger.isLoggable(Level.FINE) ? this.tracer : TracerProvider.noop().get("noop");
        SpanBuilder spanBuilder = tracer.spanBuilder("ElasticsearchBuildLogsLineIterator.skip").setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_ID, (Object)this.jobFullName).setAttribute(ExtendedJenkinsAttributes.CI_PIPELINE_RUN_NUMBER, (Object)this.runNumber).setAttribute("pointInTimeId", this.pointInTimeId).setAttribute("skipLines", skipLines.longValue());
        Span span = spanBuilder.startSpan();
        try {
            this.lineNumber = skipLines;
            if (this.delegate == null) {
                span.setAttribute("skippedLines", -1L);
            } else {
                int counter = 0;
                int i = 0;
                while ((long)i < skipLines && this.delegate.hasNext()) {
                    this.delegate.next();
                    ++counter;
                    ++i;
                }
                span.setAttribute("skippedLines", (long)counter);
            }
        }
        finally {
            span.end();
        }
    }

    static class ElasticsearchHitToFormattedLogLine
    implements Function<Hit<ObjectNode>, LogLine<Long>> {
        private String annotationsField;

        public ElasticsearchHitToFormattedLogLine(String annotationsField) {
            this.annotationsField = annotationsField;
        }

        @Override
        @Nullable
        public LogLine<Long> apply(Hit<ObjectNode> hit) {
            ObjectNode source = (ObjectNode)hit.source();
            if (source == null) {
                logger.log(Level.FINE, () -> "Skip log with no source (document id: " + hit.id() + ")");
                return null;
            }
            String message = this.extractMessage(source);
            ObjectNode labels = (ObjectNode)source.findValue(this.annotationsField);
            String annotatedMessage = this.composeAnnotatedMessage(message, labels);
            JsonNode timestampAsJsonNode = source.findValue("@timestamp");
            if (timestampAsJsonNode == null) {
                logger.log(Level.FINE, () -> "Skip log with no timestamp (document id: " + hit.id() + ")");
                return null;
            }
            long timestamp = Instant.parse(timestampAsJsonNode.asText()).toEpochMilli();
            LogLine<Long> logLine = new LogLine<Long>(timestamp, annotatedMessage);
            logger.log(Level.FINEST, () -> "Write: " + String.valueOf(logLine) + " for document.id: " + hit.id());
            return logLine;
        }

        private String composeAnnotatedMessage(@NonNull String message, @Nullable ObjectNode labels) {
            JsonNode annotationsAsText;
            JSONArray annotations = labels == null ? null : ((annotationsAsText = labels.get(ExtendedJenkinsAttributes.JENKINS_ANSI_ANNOTATIONS.getKey())) == null ? null : JSONArray.fromObject((Object)annotationsAsText.asText()));
            String annotatedMessage = ConsoleNotes.readFormattedMessage(message, annotations);
            return annotatedMessage;
        }

        @Nullable
        private String extractMessage(ObjectNode source) {
            JsonNode messageAsJsonNode = source.findValue("body");
            String msg = null;
            if ((messageAsJsonNode = messageAsJsonNode == null ? source.findValue("message") : messageAsJsonNode.get("text")) != null) {
                msg = messageAsJsonNode.asText();
            } else {
                logger.log(Level.FINE, () -> "Skip log with no body (document : " + String.valueOf(source) + ")");
            }
            return msg;
        }
    }
}

