/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend.elastic;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import groovy.text.Template;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.opentelemetry.TemplateBindingsProvider;
import io.jenkins.plugins.opentelemetry.backend.ObservabilityBackend;
import io.jenkins.plugins.opentelemetry.backend.elastic.ElasticLogsBackend;
import io.jenkins.plugins.opentelemetry.backend.elastic.ElasticsearchLogStorageRetriever;
import io.jenkins.plugins.opentelemetry.jenkins.CredentialsNotFoundException;
import io.jenkins.plugins.opentelemetry.jenkins.HttpAuthHeaderFactory;
import io.jenkins.plugins.opentelemetry.job.log.LogStorageRetriever;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ElasticLogsBackendWithJenkinsVisualization
extends ElasticLogsBackend {
    private static final String MSG_ELASTICSEARCH_URL_IS_BLANK = "Elasticsearch URL is blank, logs will not be stored in Elasticsearch";
    private static final Logger logger = Logger.getLogger(ElasticLogsBackendWithJenkinsVisualization.class.getName());
    private String elasticsearchUrl;
    private boolean disableSslVerifications;
    private String elasticsearchCredentialsId;

    @DataBoundConstructor
    public ElasticLogsBackendWithJenkinsVisualization() {
    }

    @Override
    @MustBeClosed
    public LogStorageRetriever newLogStorageRetriever(TemplateBindingsProvider templateBindingsProvider) {
        Template buildLogsVisualizationUrlTemplate = this.getBuildLogsVisualizationUrlTemplate();
        if (StringUtils.isBlank((String)this.elasticsearchUrl)) {
            logger.warning(MSG_ELASTICSEARCH_URL_IS_BLANK);
            throw new IllegalStateException(MSG_ELASTICSEARCH_URL_IS_BLANK);
        }
        return new ElasticsearchLogStorageRetriever(this.elasticsearchUrl, this.disableSslVerifications, this.elasticsearchCredentialsId, buildLogsVisualizationUrlTemplate, templateBindingsProvider);
    }

    @DataBoundSetter
    public void setElasticsearchCredentialsId(@CheckForNull String elasticsearchCredentialsId) {
        this.elasticsearchCredentialsId = elasticsearchCredentialsId;
    }

    @CheckForNull
    public String getElasticsearchCredentialsId() {
        return this.elasticsearchCredentialsId;
    }

    @CheckForNull
    public String getElasticsearchUrl() {
        return this.elasticsearchUrl;
    }

    @DataBoundSetter
    public void setElasticsearchUrl(@CheckForNull String elasticsearchUrl) {
        this.elasticsearchUrl = Util.fixNull((String)elasticsearchUrl);
    }

    public boolean isDisableSslVerifications() {
        return this.disableSslVerifications;
    }

    @DataBoundSetter
    public void setDisableSslVerifications(boolean disableSslVerifications) {
        this.disableSslVerifications = disableSslVerifications;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ElasticLogsBackendWithJenkinsVisualization that = (ElasticLogsBackendWithJenkinsVisualization)((Object)o);
        return Objects.equals(this.elasticsearchUrl, that.elasticsearchUrl) && Objects.equals(this.disableSslVerifications, that.disableSslVerifications) && Objects.equals(this.elasticsearchCredentialsId, that.elasticsearchCredentialsId);
    }

    public int hashCode() {
        return Objects.hash(this.elasticsearchUrl, this.disableSslVerifications, this.elasticsearchCredentialsId);
    }

    public String toString() {
        return "ElasticLogsBackendWithVisualizationJenkins{elasticsearchUrl='" + this.elasticsearchUrl + "', disableSslVerifications='" + this.disableSslVerifications + "', elasticsearchCredentialsId='" + this.elasticsearchCredentialsId + "'}";
    }

    @Extension(ordinal=0.0)
    public static class DescriptorImpl
    extends ElasticLogsBackend.DescriptorImpl {
        public String getDisplayName() {
            return "Store pipeline logs In Elastic and visualize logs both in Elastic and through Jenkins";
        }

        @RequirePOST
        public FormValidation doCheckElasticsearchUrl(@QueryParameter(value="elasticsearchUrl") String url) {
            if (!this.isAuthorized()) {
                return FormValidation.error((String)"You do not have permission to configure this setting.");
            }
            if (StringUtils.isEmpty((String)url)) {
                return FormValidation.ok();
            }
            try {
                new URI(url).toURL();
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
                return FormValidation.error((String)("Invalid URL: " + e.getMessage()));
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public ListBoxModel doFillElasticsearchCredentialsIdItems(@QueryParameter String elasticsearchCredentialsId) {
            if (!this.isAuthorized()) {
                return new StandardListBoxModel();
            }
            return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM2, (Item)null, StandardUsernameCredentials.class).includeCurrentValue(elasticsearchCredentialsId);
        }

        @RequirePOST
        public FormValidation doCheckElasticsearchCredentialsId(@QueryParameter String elasticsearchCredentialsId) {
            if (!this.isAuthorized()) {
                return FormValidation.error((String)"You do not have permission to configure this setting.");
            }
            if (elasticsearchCredentialsId == null || elasticsearchCredentialsId.isEmpty()) {
                return FormValidation.error((String)"Elasticsearch credentials are missing");
            }
            try {
                new HttpAuthHeaderFactory(elasticsearchCredentialsId).createAuthHeader();
            }
            catch (CredentialsNotFoundException e) {
                return FormValidation.error((String)"Elasticsearch credentials are not valid");
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doValidate(@QueryParameter String elasticsearchUrl, @QueryParameter boolean disableSslVerifications, @QueryParameter String elasticsearchCredentialsId) {
            FormValidation formValidation;
            if (!this.isAuthorized()) {
                return FormValidation.error((String)"You do not have permission to configure this setting.");
            }
            FormValidation elasticsearchUrlValidation = this.doCheckElasticsearchUrl(elasticsearchUrl);
            if (elasticsearchUrlValidation.kind != FormValidation.Kind.OK) {
                return elasticsearchUrlValidation;
            }
            ElasticsearchLogStorageRetriever elasticsearchLogStorageRetriever = new ElasticsearchLogStorageRetriever(elasticsearchUrl, disableSslVerifications, elasticsearchCredentialsId, ObservabilityBackend.ERROR_TEMPLATE, TemplateBindingsProvider.empty());
            try {
                formValidation = FormValidation.aggregate(elasticsearchLogStorageRetriever.checkElasticsearchSetup());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        elasticsearchLogStorageRetriever.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (NoSuchElementException e) {
                    return FormValidation.error((String)("No credentials found for id '" + elasticsearchCredentialsId + "'"));
                }
                catch (Exception e) {
                    return FormValidation.error((Throwable)e, (String)e.getMessage());
                }
            }
            elasticsearchLogStorageRetriever.close();
            return formValidation;
        }

        private boolean isAuthorized() {
            return Jenkins.get().hasPermission(Jenkins.ADMINISTER);
        }
    }
}

