/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend.custom;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import groovy.text.Template;
import io.jenkins.plugins.opentelemetry.TemplateBindingsProvider;
import io.jenkins.plugins.opentelemetry.job.log.LogStorageRetriever;
import io.jenkins.plugins.opentelemetry.job.log.LogsQueryResult;
import io.jenkins.plugins.opentelemetry.job.log.LogsViewHeader;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.kohsuke.stapler.framework.io.ByteBuffer;

public class CustomLogStorageRetriever
implements LogStorageRetriever {
    @NonNull
    private final Template buildLogsVisualizationUrlTemplate;
    @NonNull
    private final TemplateBindingsProvider templateBindingsProvider;

    public CustomLogStorageRetriever(@NonNull Template buildLogsVisualizationUrlTemplate, @NonNull TemplateBindingsProvider templateBindingsProvider) {
        this.buildLogsVisualizationUrlTemplate = buildLogsVisualizationUrlTemplate;
        this.templateBindingsProvider = templateBindingsProvider;
    }

    @Override
    @NonNull
    public LogsQueryResult overallLog(@NonNull String jobFullName, int runNumber, @NonNull String traceId, @NonNull String spanId, boolean complete, @NonNull Instant startTime, Instant endTime) {
        return this.getLogsQueryResult(traceId, spanId, startTime, endTime);
    }

    @Override
    @NonNull
    public LogsQueryResult stepLog(@NonNull String jobFullName, int runNumber, @NonNull String flowNodeId, @NonNull String traceId, @NonNull String spanId, boolean complete, @NonNull Instant startTime, @Nullable Instant endTime) {
        return this.getLogsQueryResult(traceId, spanId, startTime, endTime);
    }

    @NonNull
    private LogsQueryResult getLogsQueryResult(@NonNull String traceId, @NonNull String spanId, @NonNull Instant startTime, @Nullable Instant endTime) {
        HashMap<String, Object> localBindings = new HashMap<String, Object>();
        localBindings.put("traceId", traceId);
        localBindings.put("spanId", spanId);
        localBindings.put("startTime", startTime);
        localBindings.put("endTime", Optional.ofNullable(endTime).orElseGet(Instant::now));
        Map<String, Object> bindings = TemplateBindingsProvider.compose(this.templateBindingsProvider, localBindings).getBindings();
        String logsVisualizationUrl = this.buildLogsVisualizationUrlTemplate.make(bindings).toString();
        String backendName = Objects.toString(bindings.get("backendName"));
        String backend24x24IconUrl = Objects.toString(bindings.get("backend24x24IconUrl"));
        return new LogsQueryResult(new ByteBuffer(), new LogsViewHeader(backendName, logsVisualizationUrl, backend24x24IconUrl), StandardCharsets.UTF_8, true);
    }

    public String toString() {
        return "CustomLogStorageRetriever{urlTemplate=" + String.valueOf(this.buildLogsVisualizationUrlTemplate) + "}";
    }

    @Override
    public void close() throws Exception {
    }
}

