/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.backend;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.opentelemetry.backend.ObservabilityBackend;
import java.util.HashMap;
import java.util.Map;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ZipkinBackend
extends ObservabilityBackend {
    public static final String OTEL_ZIPKIN_URL = "OTEL_ZIPKIN_URL";
    public static final String DEFAULT_NAME = "Zipkin";
    private String zipkinBaseUrl;

    @DataBoundConstructor
    public ZipkinBackend() {
    }

    @Override
    public Map<String, Object> mergeBindings(Map<String, Object> bindings) {
        HashMap<String, Object> mergedBindings = new HashMap<String, Object>(bindings);
        mergedBindings.put("zipkinBaseUrl", this.zipkinBaseUrl);
        return mergedBindings;
    }

    @Override
    @CheckForNull
    public String getTraceVisualisationUrlTemplate() {
        return "${zipkinBaseUrl}traces/${traceId}";
    }

    public String getZipkinBaseUrl() {
        return this.zipkinBaseUrl;
    }

    @DataBoundSetter
    public void setZipkinBaseUrl(String zipkinBaseUrl) {
        if (zipkinBaseUrl != null && !((String)zipkinBaseUrl).endsWith("/")) {
            zipkinBaseUrl = (String)zipkinBaseUrl + "/";
        }
        this.zipkinBaseUrl = zipkinBaseUrl;
    }

    @Override
    @CheckForNull
    public String getIconPath() {
        return "icon-otel-zipkin";
    }

    @Override
    @CheckForNull
    public String getEnvVariableName() {
        return OTEL_ZIPKIN_URL;
    }

    @Override
    @CheckForNull
    public String getDefaultName() {
        return DEFAULT_NAME;
    }

    @Override
    @CheckForNull
    public String getMetricsVisualizationUrlTemplate() {
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj instanceof ZipkinBackend;
    }

    @Override
    public int hashCode() {
        return ZipkinBackend.class.hashCode();
    }

    @Override
    public Map<String, Object> getBindings() {
        return Map.of("backendName", this.getName(), "backend24x24IconUrl", "/plugin/opentelemetry/images/24x24/zipkin.png");
    }

    static {
        IconSet.icons.addIcon(new Icon("icon-otel-zipkin icon-sm", "plugin/opentelemetry/images/svgs/zipkin.svg", "width: 16px; height: 16px;"));
        IconSet.icons.addIcon(new Icon("icon-otel-zipkin icon-md", "plugin/opentelemetry/images/svgs/zipkin.svg", "width: 24px; height: 24px;"));
        IconSet.icons.addIcon(new Icon("icon-otel-zipkin icon-lg", "plugin/opentelemetry/images/svgs/zipkin.svg", "width: 32px; height: 32px;"));
        IconSet.icons.addIcon(new Icon("icon-otel-zipkin icon-xlg", "plugin/opentelemetry/images/svgs/zipkin.svg", "width: 48px; height: 48px;"));
    }

    @Extension
    @Symbol(value={"zipkin"})
    public static class DescriptorImpl
    extends ObservabilityBackend.ObservabilityBackendDescriptor {
        @NonNull
        public String getDisplayName() {
            return ZipkinBackend.DEFAULT_NAME;
        }
    }
}

