/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.authentication;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.opentelemetry.authentication.OtlpAuthentication;
import io.jenkins.plugins.opentelemetry.semconv.ConfigurationKey;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.springframework.security.core.Authentication;

@Extension
public class HeaderAuthentication
extends OtlpAuthentication {
    private static final Logger LOGGER = Logger.getLogger(HeaderAuthentication.class.getName());
    private String headerName;
    private String headerValueId;

    @DataBoundConstructor
    public HeaderAuthentication() {
    }

    private String getAuthenticationHeaderValue() {
        String authenticationTokenValue;
        StringCredentials credentials = (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(StringCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM2, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.headerValueId));
        if (credentials == null) {
            LOGGER.log(Level.WARNING, () -> "StringCredentials with id `" + this.headerValueId + "` not found. Fall back to empty secret, an authentication error is likely to happen.");
            authenticationTokenValue = "";
        } else {
            authenticationTokenValue = Secret.toString((Secret)credentials.getSecret());
        }
        return authenticationTokenValue;
    }

    @Override
    public void enrichOpenTelemetryAutoConfigureConfigProperties(Map<String, String> configProperties) {
        configProperties.put(ConfigurationKey.OTEL_EXPORTER_OTLP_HEADERS.asProperty(), this.getHeaderName() + "=" + this.getAuthenticationHeaderValue());
    }

    @Override
    public void enrichOtelEnvironmentVariables(Map<String, String> environmentVariables) {
        environmentVariables.put(ConfigurationKey.OTEL_EXPORTER_OTLP_HEADERS.asEnvVar(), this.getHeaderName() + "=" + this.getAuthenticationHeaderValue());
    }

    public String getHeaderName() {
        return this.headerName;
    }

    @DataBoundSetter
    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getHeaderValueId() {
        return this.headerValueId;
    }

    @DataBoundSetter
    public void setHeaderValueId(String headerValueId) {
        this.headerValueId = headerValueId;
    }

    public String toString() {
        return "OtlpHeaderAuthentication{headerName='" + this.headerName + "', headerValueId='" + this.headerValueId + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeaderAuthentication that = (HeaderAuthentication)o;
        return Objects.equals(this.headerName, that.headerName) && Objects.equals(this.headerValueId, that.headerValueId);
    }

    public int hashCode() {
        return Objects.hash(this.headerName, this.headerValueId);
    }

    @Extension
    @Symbol(value={"otlpHeaderAuthentication"})
    public static class DescriptorImpl
    extends OtlpAuthentication.AbstractDescriptor {
        public String getDisplayName() {
            return "Header Authentication";
        }

        public ListBoxModel doFillHeaderValueIdItems() {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return new StandardListBoxModel();
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, (ItemGroup)Jenkins.get(), StringCredentials.class, Collections.emptyList(), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StringCredentials.class)}));
        }
    }
}

