/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public interface TemplateBindingsProvider {
    public static TemplateBindingsProvider empty() {
        return Collections::emptyMap;
    }

    public static TemplateBindingsProvider of(Map<String, Object> bindings) {
        return () -> bindings;
    }

    public static TemplateBindingsProvider of(String key, String value) {
        return TemplateBindingsProvider.of(Collections.singletonMap(key, value));
    }

    public static TemplateBindingsProvider of(String key1, String value1, String key2, String value2) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(2);
        map.put(key1, value1);
        map.put(key2, value2);
        return TemplateBindingsProvider.of(map);
    }

    public static TemplateBindingsProvider compose(TemplateBindingsProvider templateBindingsProvider, Map<String, Object> bindings) {
        return () -> {
            HashMap<String, Object> newBindings = new HashMap<String, Object>(templateBindingsProvider.getBindings());
            newBindings.putAll(bindings);
            return newBindings;
        };
    }

    public Map<String, Object> getBindings();
}

