/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.opentelemetry.OtelUtils;
import io.jenkins.plugins.opentelemetry.authentication.OtlpAuthentication;
import io.jenkins.plugins.opentelemetry.semconv.ConfigurationKey;
import io.jenkins.plugins.opentelemetry.semconv.ExtendedJenkinsAttributes;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import io.opentelemetry.semconv.ServiceAttributes;
import io.opentelemetry.semconv.incubating.ServiceIncubatingAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class OpenTelemetryConfiguration {
    @SuppressFBWarnings
    @VisibleForTesting
    public static boolean TESTING_INMEMORY_MODE = false;
    private final Optional<String> endpoint;
    private final Optional<String> trustedCertificatesPem;
    private final Optional<OtlpAuthentication> authentication;
    private final Optional<String> serviceName;
    private final Optional<String> serviceNamespace;
    private final Optional<String> disabledResourceProviders;
    private final Map<String, String> configurationProperties;

    public OpenTelemetryConfiguration(Optional<String> endpoint, Optional<String> trustedCertificatesPem, Optional<OtlpAuthentication> authentication, Optional<String> serviceName, Optional<String> serviceNamespace, Optional<String> disabledResourceProviders, Map<String, String> configurationProperties) {
        this.endpoint = endpoint.filter(StringUtils::isNotBlank);
        this.trustedCertificatesPem = trustedCertificatesPem.filter(StringUtils::isNotBlank);
        this.authentication = authentication;
        this.serviceName = serviceName.filter(StringUtils::isNotBlank);
        this.serviceNamespace = serviceNamespace.filter(StringUtils::isNotBlank);
        this.disabledResourceProviders = disabledResourceProviders.filter(StringUtils::isNotBlank);
        this.configurationProperties = configurationProperties;
        this.getEndpoint().ifPresent(ep -> Preconditions.checkArgument((ep.startsWith("http://") || ep.startsWith("https://") ? 1 : 0) != 0, (String)"endpoint must be prefixed by 'http://' or 'https://': %s", (Object)ep));
    }

    public Optional<String> getEndpoint() {
        return this.endpoint;
    }

    public Optional<String> getServiceName() {
        return this.serviceName;
    }

    public Optional<String> getServiceNamespace() {
        return this.serviceNamespace;
    }

    public Optional<OtlpAuthentication> getAuthentication() {
        return this.authentication;
    }

    public Optional<String> getTrustedCertificatesPem() {
        return this.trustedCertificatesPem;
    }

    public Optional<String> getDisabledResourceProviders() {
        return this.disabledResourceProviders;
    }

    @NonNull
    public Map<String, String> toOpenTelemetryProperties() {
        HashMap<String, String> properties = new HashMap<String, String>(this.configurationProperties);
        if (TESTING_INMEMORY_MODE) {
            properties.putIfAbsent(ConfigurationKey.OTEL_TRACES_EXPORTER.asProperty(), "testing");
            properties.putIfAbsent(ConfigurationKey.OTEL_METRICS_EXPORTER.asProperty(), "testing");
            properties.putIfAbsent(ConfigurationKey.OTEL_METRIC_EXPORT_INTERVAL.asProperty(), "10ms");
            properties.putIfAbsent(ConfigurationKey.OTEL_LOGS_EXPORTER.asProperty(), "none");
        } else if (this.getEndpoint().isPresent()) {
            this.getEndpoint().ifPresent(endpoint -> {
                properties.compute(ConfigurationKey.OTEL_TRACES_EXPORTER.asProperty(), (key, oldValue) -> {
                    if (oldValue == null) {
                        return "otlp";
                    }
                    if ("none".equals(oldValue)) {
                        return "none";
                    }
                    if (oldValue.contains("otlp")) {
                        return oldValue;
                    }
                    return oldValue.concat(",otlp");
                });
                properties.compute(ConfigurationKey.OTEL_METRICS_EXPORTER.asProperty(), (key, oldValue) -> {
                    if (oldValue == null) {
                        return "otlp";
                    }
                    if ("none".equals(oldValue)) {
                        return "none";
                    }
                    if (oldValue.contains("otlp")) {
                        return oldValue;
                    }
                    return oldValue.concat(",otlp");
                });
                properties.put(ConfigurationKey.OTEL_EXPORTER_OTLP_ENDPOINT.asProperty(), (String)endpoint);
            });
        } else if (StringUtils.isBlank((String)OtelUtils.getSystemPropertyOrEnvironmentVariable("OTEL_TRACES_EXPORTER")) && StringUtils.isBlank((String)OtelUtils.getSystemPropertyOrEnvironmentVariable("OTEL_EXPORTER_OTLP_ENDPOINT")) && StringUtils.isBlank((String)OtelUtils.getSystemPropertyOrEnvironmentVariable("OTEL_EXPORTER_OTLP_TRACES_ENDPOINT"))) {
            properties.put(ConfigurationKey.OTEL_TRACES_EXPORTER.asProperty(), "none");
        }
        this.getTrustedCertificatesPem().ifPresent(trustedCertificatesPem -> properties.put(ConfigurationKey.OTEL_EXPORTER_OTLP_CERTIFICATE.asProperty(), (String)trustedCertificatesPem));
        this.getAuthentication().ifPresent(authentication -> authentication.enrichOpenTelemetryAutoConfigureConfigProperties(properties));
        this.getDisabledResourceProviders().ifPresent(disabledResourceProviders -> properties.put(ConfigurationKey.OTEL_JAVA_DISABLED_RESOURCE_PROVIDERS.asProperty(), (String)disabledResourceProviders));
        return properties;
    }

    @NonNull
    public Resource toOpenTelemetryResource() {
        ResourceBuilder resourceBuilder = Resource.builder();
        this.getServiceName().ifPresent(serviceName -> resourceBuilder.put(ServiceAttributes.SERVICE_NAME, serviceName));
        this.getServiceNamespace().ifPresent(serviceNamespace -> resourceBuilder.put(ServiceIncubatingAttributes.SERVICE_NAMESPACE, serviceNamespace));
        resourceBuilder.put(ExtendedJenkinsAttributes.JENKINS_OPEN_TELEMETRY_PLUGIN_VERSION, (Object)OtelUtils.getOpentelemetryPluginVersion());
        return resourceBuilder.build();
    }

    @NonNull
    public Map<String, String> toOpenTelemetryResourceAsMap() {
        HashMap<String, String> resourceMap = new HashMap<String, String>();
        this.getServiceName().ifPresent(serviceName -> resourceMap.put(ServiceAttributes.SERVICE_NAME.getKey(), (String)serviceName));
        this.getServiceNamespace().ifPresent(serviceNamespace -> resourceMap.put(ServiceIncubatingAttributes.SERVICE_NAMESPACE.getKey(), (String)serviceNamespace));
        resourceMap.put(ExtendedJenkinsAttributes.JENKINS_OPEN_TELEMETRY_PLUGIN_VERSION.getKey(), OtelUtils.getOpentelemetryPluginVersion());
        return resourceMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenTelemetryConfiguration that = (OpenTelemetryConfiguration)o;
        return Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.authentication, that.authentication) && Objects.equals(this.trustedCertificatesPem, that.trustedCertificatesPem) && Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.serviceNamespace, that.serviceNamespace) && Objects.equals(this.disabledResourceProviders, that.disabledResourceProviders) && Objects.equals(this.configurationProperties, that.configurationProperties);
    }

    public int hashCode() {
        return Objects.hash(this.endpoint, this.authentication, this.trustedCertificatesPem, this.serviceName, this.serviceNamespace, this.disabledResourceProviders, this.configurationProperties);
    }

    public String toString() {
        return "OpenTelemetryConfiguration{endpoint='" + String.valueOf(this.endpoint) + "', trustedCertificatesPem.defined=" + this.trustedCertificatesPem.isPresent() + ", authentication=" + String.valueOf(this.authentication) + ", serviceName=" + String.valueOf(this.serviceName) + ", serviceNamespace=" + String.valueOf(this.serviceNamespace) + ", disabledResourceProviders=" + String.valueOf(this.disabledResourceProviders) + "}";
    }
}

