/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.InvisibleAction;
import io.opentelemetry.api.common.AttributeKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OpenTelemetryAttributesAction
extends InvisibleAction
implements Serializable {
    private static final long serialVersionUID = 5488506456727905116L;
    private transient Map<AttributeKey<?>, Object> attributes;
    private transient Set<String> appliedToSpans;
    private transient List<String> inheritanceAllowedSpanIdList;

    @NonNull
    public Map<AttributeKey<?>, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        return this.attributes;
    }

    public boolean isNotYetAppliedToSpan(String spanId) {
        if (this.appliedToSpans == null) {
            this.appliedToSpans = new HashSet<String>();
        }
        return this.appliedToSpans.add(spanId);
    }

    public void addSpanIdToInheritanceAllowedList(String spanId) {
        if (this.inheritanceAllowedSpanIdList == null) {
            this.inheritanceAllowedSpanIdList = new ArrayList<String>();
        }
        this.inheritanceAllowedSpanIdList.add(spanId);
    }

    public boolean inheritanceAllowedSpanIdListIsEmpty() {
        if (this.inheritanceAllowedSpanIdList == null) {
            return true;
        }
        return this.inheritanceAllowedSpanIdList.isEmpty();
    }

    public boolean isSpanIdAllowedToInheritAttributes(String spanId) {
        if (this.inheritanceAllowedSpanIdList == null) {
            return false;
        }
        return this.inheritanceAllowedSpanIdList.contains(spanId);
    }

    public String toString() {
        return "OpenTelemetryAttributesAction{attributes=" + this.getAttributes().entrySet().stream().map(e -> ((AttributeKey)e.getKey()).getKey() + "-" + String.valueOf(((AttributeKey)e.getKey()).getType()) + " - " + String.valueOf(e.getValue())).collect(Collectors.joining(", ")) + "}";
    }
}

