/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import io.jenkins.plugins.opentelemetry.OpenTelemetryConfiguration;
import io.jenkins.plugins.opentelemetry.OtelUtils;
import io.jenkins.plugins.opentelemetry.api.ReconfigurableOpenTelemetry;
import io.jenkins.plugins.opentelemetry.semconv.ConfigurationKey;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.instrumentation.resources.ProcessResourceProvider;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

@Extension(ordinal=2.147483647E9)
public class JenkinsControllerOpenTelemetry
implements ExtensionPoint {
    public static final String DEFAULT_OTEL_JAVA_DISABLED_RESOURCE_PROVIDERS = ProcessResourceProvider.class.getName();
    @Inject
    @VisibleForTesting
    protected ReconfigurableOpenTelemetry openTelemetry;
    private Tracer defaultTracer;
    private Meter defaultMeter;

    @PostConstruct
    public void postConstruct() {
        String opentelemetryPluginVersion = OtelUtils.getOpentelemetryPluginVersion();
        this.defaultTracer = this.openTelemetry.tracerBuilder("io.jenkins.opentelemetry").setInstrumentationVersion(opentelemetryPluginVersion).build();
        this.defaultMeter = this.openTelemetry.meterBuilder("io.jenkins.opentelemetry").setInstrumentationVersion(opentelemetryPluginVersion).build();
    }

    @NonNull
    public Tracer getDefaultTracer() {
        return this.defaultTracer;
    }

    @NonNull
    public Meter getDefaultMeter() {
        return this.defaultMeter;
    }

    public boolean isLogsEnabled() {
        String otelLogsExporter = this.openTelemetry.getConfig().getString(ConfigurationKey.OTEL_LOGS_EXPORTER.asProperty(), "none");
        return !Objects.equals(otelLogsExporter, "none");
    }

    public boolean isOtelLogsMirrorToDisk() {
        String mirrorLogsToDisk = this.openTelemetry.getConfig().getString(ConfigurationKey.OTEL_LOGS_MIRROR_TO_DISK.asProperty(), "false");
        return Objects.equals(mirrorLogsToDisk, "true");
    }

    @Deprecated
    @VisibleForTesting
    @NonNull
    protected OpenTelemetrySdk getOpenTelemetrySdk() {
        return (OpenTelemetrySdk)Optional.ofNullable(this.openTelemetry).map(ReconfigurableOpenTelemetry::getImplementation).orElseThrow(() -> new IllegalStateException("OpenTelemetry not initialized"));
    }

    public void initialize(@NonNull OpenTelemetryConfiguration configuration) {
        this.openTelemetry.configure(configuration.toOpenTelemetryProperties(), configuration.toOpenTelemetryResource(), true);
    }

    public static JenkinsControllerOpenTelemetry get() {
        return (JenkinsControllerOpenTelemetry)ExtensionList.lookupSingleton(JenkinsControllerOpenTelemetry.class);
    }
}

