/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.onmonit.util;

import hudson.Launcher;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.onmonit.util.AvailablePort;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import jenkins.security.MasterToSlaveCallable;

public class AvailablePortRetriever {
    private static final Map<VirtualChannel, Semaphore> syncPortRetrieval = new ConcurrentHashMap<VirtualChannel, Semaphore>();

    public static Semaphore getSyncOjbectForLauncher(Launcher launcher) {
        return syncPortRetrieval.computeIfAbsent(launcher.getChannel(), c -> new Semaphore(1));
    }

    public static AvailablePort getAvailablePort(Launcher launcher, int basePort, int maxPort) {
        try {
            VirtualChannel ch = launcher.getChannel();
            if (ch == null) {
                throw new IllegalArgumentException("Channel is null");
            }
            Semaphore syncObj = syncPortRetrieval.computeIfAbsent(ch, c -> new Semaphore(1));
            if (syncObj.availablePermits() != 0) {
                throw new IllegalArgumentException("Caller is supposed to sync");
            }
            return (AvailablePort)ch.call((Callable)new AvailablePortCallable(basePort, maxPort));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static class AvailablePortCallable
    extends MasterToSlaveCallable<AvailablePort, Throwable> {
        private static final long serialVersionUID = -4472949825725190221L;
        private int basePort;
        private int maxPort;

        AvailablePortCallable(int basePort, int maxPort) {
            this.basePort = basePort;
            this.maxPort = maxPort;
        }

        public AvailablePort call() throws Throwable {
            int tryPort = this.basePort;
            while (tryPort < this.maxPort) {
                AvailablePort availablePort;
                ServerSocket serverSocket = new ServerSocket(tryPort);
                try {
                    availablePort = new AvailablePort(tryPort);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            serverSocket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        ++tryPort;
                    }
                }
                serverSocket.close();
                return availablePort;
            }
            throw new RuntimeException("Could not find open port in range " + this.basePort + "-" + this.maxPort);
        }
    }
}

