/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.onmonit.exec;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import io.jenkins.plugins.onmonit.LauncherProvider;
import io.jenkins.plugins.onmonit.RemoteNodeExporterProcess;
import io.jenkins.plugins.onmonit.RemoteNodeExporterProcessFactory;
import io.jenkins.plugins.onmonit.exec.ExecDownloadedNodeExporterProcessFactory;
import io.jenkins.plugins.onmonit.exec.ExecRemoteNodeExporterProcessFactory;
import io.jenkins.plugins.onmonit.exec.ExecUploadedNodeExporterProcessFactory;
import io.jenkins.plugins.onmonit.util.ComputerInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@Extension
public class DelegatedNodeExporterProcessFactory
extends RemoteNodeExporterProcessFactory {
    private static final List<RemoteNodeExporterProcessFactory> delegates = List.of(new ExecRemoteNodeExporterProcessFactory(), new ExecDownloadedNodeExporterProcessFactory(), new ExecUploadedNodeExporterProcessFactory());

    @Override
    public String getDisplayName() {
        return "Delegated exec node_exporter (fixed order delegation to other process factories)";
    }

    @Override
    public boolean isSupported(Launcher launcher, TaskListener listener, ComputerInfo info) {
        return true;
    }

    @Override
    public RemoteNodeExporterProcess create(LauncherProvider launcherProvider, TaskListener listener, ComputerInfo info, FilePath temp, String envCookie, String additionalOptions, boolean debug) throws Throwable {
        Launcher launcher = launcherProvider.getLauncher();
        LinkedHashMap<String, Throwable> faults = new LinkedHashMap<String, Throwable>();
        for (RemoteNodeExporterProcessFactory remoteNodeExporterProcessFactory : delegates) {
            if (!remoteNodeExporterProcessFactory.isSupported(launcher, listener, info)) continue;
            try {
                listener.getLogger().println("[on-monit]   " + remoteNodeExporterProcessFactory.getDisplayName());
                return remoteNodeExporterProcessFactory.create(launcherProvider, listener, info, temp, envCookie, additionalOptions, debug);
            }
            catch (Throwable t) {
                faults.put(remoteNodeExporterProcessFactory.getDisplayName(), t);
            }
        }
        for (Map.Entry entry : faults.entrySet()) {
            listener.getLogger().println("[on-monit] * " + (String)entry.getKey());
            StringWriter sw = new StringWriter();
            ((Throwable)entry.getValue()).printStackTrace(new PrintWriter(sw));
            for (String line : StringUtils.split((String)sw.toString(), (String)"\n")) {
                listener.getLogger().println("[on-monit]     " + line);
            }
        }
        throw new RuntimeException("Could not start process node_exporter");
    }
}

