/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.onmonit;

import hudson.EnvVars;
import hudson.model.Run;
import io.jenkins.plugins.onmonit.ONMonitConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import jenkins.model.Jenkins;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.StringTemplateResolver;

public class ONTemplating {
    private static volatile TemplateEngine defaultTemplateEngine = null;
    private static volatile TemplateEngine configTemplateEngine = null;

    TemplateEngine getDefaultTemplateEngine() {
        if (defaultTemplateEngine != null) {
            return defaultTemplateEngine;
        }
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver(this.getClass().getClassLoader());
        templateResolver.setTemplateMode(TemplateMode.TEXT);
        templateResolver.setPrefix("io/jenkins/plugins/onmonit/");
        templateResolver.setSuffix(".tmpl");
        templateResolver.setCharacterEncoding(StandardCharsets.UTF_8.name());
        templateResolver.setCheckExistence(true);
        TemplateEngine tEngine = new TemplateEngine();
        tEngine.setTemplateResolver((ITemplateResolver)templateResolver);
        defaultTemplateEngine = tEngine;
        return defaultTemplateEngine;
    }

    TemplateEngine getStringTemplateEngine() {
        if (configTemplateEngine != null) {
            return configTemplateEngine;
        }
        StringTemplateResolver templateResolver = new StringTemplateResolver();
        templateResolver.setTemplateMode(TemplateMode.TEXT);
        TemplateEngine tEngine = new TemplateEngine();
        tEngine.setTemplateResolver((ITemplateResolver)templateResolver);
        configTemplateEngine = tEngine;
        return configTemplateEngine;
    }

    String renderTemplate(Context context) {
        String template = ONMonitConfig.get().getOtelConfigTemplate();
        if (template.isEmpty()) {
            return this.getDefaultTemplateEngine().process("otel.yaml", (IContext)context);
        }
        return this.getStringTemplateEngine().process(template, (IContext)context);
    }

    private String toOtelCompatibleUrl(String urlStr) {
        try {
            URL url = new URL(urlStr);
            if (url.getPort() == -1) {
                url = new URL(url.getProtocol(), url.getHost(), url.getDefaultPort(), url.getFile());
            }
            if ("/".equals(url.getFile())) {
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), "");
            }
            return url.toString();
        }
        catch (MalformedURLException e) {
            return urlStr;
        }
    }

    private String trimSuffix(String original, String suffix) {
        if (original.endsWith(suffix)) {
            return original.substring(0, original.length() - suffix.length());
        }
        return original;
    }

    private String trimWithDefault(String original, String suffix, String _default) {
        String trimmed = this.trimSuffix(original, suffix);
        return trimmed.isEmpty() ? _default : this.trimSuffix(trimmed, "/");
    }

    public Context getJobContext(Run<?, ?> run, EnvVars environment, int port) {
        Context context = new Context();
        String pageUrl = Jenkins.get().getRootUrl() + run.getUrl();
        String otlpEndpoint = (String)environment.get((Object)"OTEL_EXPORTER_OTLP_ENDPOINT");
        String otlpHeader = (String)environment.get((Object)"OTEL_EXPORTER_OTLP_HEADERS");
        String serviceName = (String)environment.get((Object)"OTEL_SERVICE_NAME");
        if (serviceName == null) {
            serviceName = ONMonitConfig.get().getOtelServiceName();
        }
        String jobName = (String)environment.get((Object)"JOB_NAME");
        String jobBaseName = (String)environment.get((Object)"JOB_BASE_NAME");
        context.setVariable("JENKINS_URL", (Object)Jenkins.get().getRootUrl());
        context.setVariable("pageUrl", (Object)pageUrl);
        context.setVariable("env", (Object)environment);
        context.setVariable("nePort", (Object)port);
        context.setVariable("serviceName", (Object)serviceName);
        context.setVariable("jobName", (Object)jobName);
        context.setVariable("jobGroupName", (Object)this.trimWithDefault(jobName, jobBaseName, "-"));
        context.setVariable("otlpEndpoint", (Object)this.toOtelCompatibleUrl(otlpEndpoint));
        if (otlpHeader == null || otlpHeader.isEmpty()) {
            context.setVariable("otlpAuthHeaderBefore", (Object)"");
            context.setVariable("otlpAuthHeader", (Object)"");
            context.setVariable("otlpAuthHeaderAfter", (Object)"");
        } else {
            String otlpAuthHeader = otlpHeader.substring(otlpHeader.indexOf("=") + 1);
            context.setVariable("otlpAuthHeaderBefore", (Object)"headers:\n      Authorization: '");
            context.setVariable("otlpAuthHeader", (Object)otlpAuthHeader);
            context.setVariable("otlpAuthHeaderAfter", (Object)"'");
        }
        return context;
    }

    public UrlContext getUrlContext(EnvVars environment) {
        String jobBaseName = (String)environment.get((Object)"JOB_BASE_NAME");
        String jobName = (String)environment.get((Object)"JOB_NAME");
        String jobGroup = this.trimWithDefault(jobName, jobBaseName, "-");
        String jobId = (String)environment.get((Object)"BUILD_ID");
        return new UrlContext(jobGroup, jobName, jobId);
    }

    public String getVisualisationUrl(String urlTemplate, Map<String, String> context) {
        String result = urlTemplate;
        for (Map.Entry<String, String> entry : context.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            result = result.replaceAll("\\{" + entry.getKey() + "\\}", URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8));
        }
        return result;
    }

    public static class UrlContext {
        private final String jobGroup;
        private final String jobName;
        private final String jobId;

        public UrlContext(String jobGroup, String jobName, String jobId) {
            this.jobGroup = jobGroup;
            this.jobName = jobName;
            this.jobId = jobId;
        }

        public String getJobGroup() {
            return this.jobGroup;
        }

        public String getJobName() {
            return this.jobName;
        }

        public String getJobId() {
            return this.jobId;
        }
    }
}

