/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.onmonit;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.util.FormValidation;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jenkins.YesNoMaybe;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

@Extension(dynamicLoadable=YesNoMaybe.YES)
@Symbol(value={"onMonitConfig"})
public final class ONMonitConfig
extends GlobalConfiguration {
    private static final Pattern urlVariable = Pattern.compile("\\{([^}]*)\\}");
    private static final Set<String> validVariables = Set.of("jobGroup", "jobName", "jobId", "startTime", "endTime");
    private static final String ICONS_PREFIX = "plugin/opentelemetry-agent-metrics/images/svgs/";
    private static final String ICON_GRAFANA = "plugin/opentelemetry-agent-metrics/images/svgs/grafana.svg";
    private static final String ICON_OTEL = "plugin/opentelemetry-agent-metrics/images/svgs/opentelemetry.svg";
    public static final String ICON_CLASS_GRAFANA = "icon-onmonit-grafana";
    public static final String ICON_CLASS_OTEL = "icon-onmonit-otel";
    @CheckForNull
    private String grafanaDashboard;
    @CheckForNull
    private String downloadBaseUrl;
    @CheckForNull
    private String neDefaultAdditionalOptions;
    @CheckForNull
    private String ocDefaultAdditionalOptions;
    @CheckForNull
    private String otelConfigTemplate;
    @CheckForNull
    private String otelServiceName;

    public static ONMonitConfig get() {
        return (ONMonitConfig)((Object)ExtensionList.lookupSingleton(ONMonitConfig.class));
    }

    public ONMonitConfig() {
        this.load();
    }

    public String getGrafanaDashboard() {
        return this.grafanaDashboard == null ? "" : this.grafanaDashboard;
    }

    public void setGrafanaDashboard(@CheckForNull String grafanaDashboard) {
        this.grafanaDashboard = grafanaDashboard != null ? grafanaDashboard.trim() : null;
        this.save();
    }

    @POST
    public FormValidation doCheckGrafanaDashboard(@QueryParameter String grafanaDashboard) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (Util.fixEmptyAndTrim((String)grafanaDashboard) == null) {
            return FormValidation.ok();
        }
        String badVariables = urlVariable.matcher(grafanaDashboard).results().map(result -> result.group(1)).filter(v -> !validVariables.contains(v)).collect(Collectors.joining("}, {"));
        if (!badVariables.isEmpty()) {
            return FormValidation.error((String)("Bad variables: {" + badVariables + "}"));
        }
        String urlWithoutVariables = urlVariable.matcher(grafanaDashboard).replaceAll("varValue");
        return ONMonitConfig.validateUrl(urlWithoutVariables);
    }

    public String getDownloadBaseUrl() {
        return this.downloadBaseUrl == null ? "" : this.downloadBaseUrl;
    }

    public void setDownloadBaseUrl(@CheckForNull String downloadBaseUrl) {
        this.downloadBaseUrl = downloadBaseUrl != null ? downloadBaseUrl.trim() : null;
        this.save();
    }

    @POST
    public FormValidation doCheckDownloadBaseUrl(@QueryParameter String downloadBaseUrl) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (Util.fixEmptyAndTrim((String)downloadBaseUrl) == null) {
            return FormValidation.ok();
        }
        return ONMonitConfig.validateUrl(downloadBaseUrl);
    }

    public String getNeDefaultAdditionalOptions() {
        return this.neDefaultAdditionalOptions == null ? "" : this.neDefaultAdditionalOptions;
    }

    public void setNeDefaultAdditionalOptions(@CheckForNull String defaultAdditionalOptions) {
        this.neDefaultAdditionalOptions = defaultAdditionalOptions != null ? defaultAdditionalOptions.trim() : null;
        this.save();
    }

    public String getOcDefaultAdditionalOptions() {
        return this.ocDefaultAdditionalOptions == null ? "" : this.ocDefaultAdditionalOptions;
    }

    public void setOcDefaultAdditionalOptions(@CheckForNull String defaultAdditionalOptions) {
        this.ocDefaultAdditionalOptions = defaultAdditionalOptions != null ? defaultAdditionalOptions.trim() : null;
        this.save();
    }

    public String getOtelConfigTemplate() {
        return this.otelConfigTemplate == null ? "" : this.otelConfigTemplate;
    }

    public void setOtelConfigTemplate(@CheckForNull String otelConfigTemplate) {
        this.otelConfigTemplate = otelConfigTemplate != null ? otelConfigTemplate.trim() : null;
        this.save();
    }

    public String getOtelServiceName() {
        return this.otelServiceName == null ? "" : this.otelServiceName;
    }

    public void setOtelServiceName(@CheckForNull String otelServiceName) {
        this.otelServiceName = otelServiceName != null ? otelServiceName.trim() : null;
        this.save();
    }

    private static FormValidation validateUrl(@NonNull String url) {
        try {
            new URL(url).toURI();
            return FormValidation.ok();
        }
        catch (MalformedURLException | URISyntaxException e) {
            return FormValidation.error((String)"Invalid URL");
        }
    }

    static {
        IconSet.icons.addIcon(new Icon("icon-onmonit-grafana icon-sm", ICON_GRAFANA, "width: 16px; height: 16px;"));
        IconSet.icons.addIcon(new Icon("icon-onmonit-grafana icon-md", ICON_GRAFANA, "width: 24px; height: 24px;"));
        IconSet.icons.addIcon(new Icon("icon-onmonit-grafana icon-lg", ICON_GRAFANA, "width: 32px; height: 32px;"));
        IconSet.icons.addIcon(new Icon("icon-onmonit-grafana icon-xlg", ICON_GRAFANA, "width: 48px; height: 48px;"));
        IconSet.icons.addIcon(new Icon("icon-onmonit-otel icon-sm", ICON_OTEL, "width: 16px; height: 16px;"));
        IconSet.icons.addIcon(new Icon("icon-onmonit-otel icon-md", ICON_OTEL, "width: 24px; height: 24px;"));
        IconSet.icons.addIcon(new Icon("icon-onmonit-otel icon-lg", ICON_OTEL, "width: 32px; height: 32px;"));
        IconSet.icons.addIcon(new Icon("icon-onmonit-otel icon-xlg", ICON_OTEL, "width: 48px; height: 48px;"));
    }
}

