/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.onmonit.exec;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.util.ArgumentListBuilder;
import io.jenkins.plugins.onmonit.LauncherProvider;
import io.jenkins.plugins.onmonit.ONMonitConfig;
import io.jenkins.plugins.onmonit.ResourceUtil;
import io.jenkins.plugins.onmonit.exec.ExecRemoteNodeExporterProcess;
import io.jenkins.plugins.onmonit.util.ComputerInfo;
import io.jenkins.plugins.onmonit.util.DownloadOnSlaveCallable;
import java.io.IOException;

public class ExecDownloadedNodeExporterProcess
extends ExecRemoteNodeExporterProcess {
    ExecDownloadedNodeExporterProcess(LauncherProvider launcherProvider, TaskListener listener, ComputerInfo info, FilePath temp, String envCookie, String additionalOptions, boolean debug) throws Exception {
        super(launcherProvider, listener, info, temp, envCookie, additionalOptions, debug);
    }

    @Override
    protected ArgumentListBuilder getCmd() throws IOException, InterruptedException {
        FilePath executableFile = this.createTempExecutableFile();
        String url = ONMonitConfig.get().getDownloadBaseUrl() + "/" + ResourceUtil.getNodeExporterFilename(this.info.getOs(), this.info.isAmd64());
        try {
            VirtualChannel channel = this.launcherProvider.getLauncher().getChannel();
            if (channel == null) {
                throw new RuntimeException("Could not access channel");
            }
            channel.call((Callable)new DownloadOnSlaveCallable(url, executableFile.getRemote()));
            executableFile.chmod(493);
            return new ArgumentListBuilder(new String[]{executableFile.getRemote()});
        }
        catch (InterruptedException e) {
            this.listener.fatalError("InterruptedException while writing node_exporter executable %s", new Object[]{e});
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            this.listener.fatalError("IOException while writing node_exporter executable %s", new Object[]{e});
        }
        throw new RuntimeException("could not start node_exporter");
    }
}

