/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.engine.AbstractGatheringModelProcessable;
import org.thymeleaf.engine.Model;
import org.thymeleaf.engine.ProcessorExecutionVars;
import org.thymeleaf.engine.ProcessorTemplateHandler;
import org.thymeleaf.engine.TemplateFlowController;
import org.thymeleaf.engine.TemplateModelController;

final class GatheringModelProcessable
extends AbstractGatheringModelProcessable {
    private final IEngineContext context;
    private int offset;

    GatheringModelProcessable(IEngineConfiguration configuration, ProcessorTemplateHandler processorTemplateHandler, IEngineContext context, TemplateModelController modelController, TemplateFlowController flowController, TemplateModelController.SkipBody gatheredSkipBody, boolean gatheredSkipCloseTag, ProcessorExecutionVars processorExecutionVars) {
        super(configuration, processorTemplateHandler, context, modelController, flowController, gatheredSkipBody, gatheredSkipCloseTag, processorExecutionVars);
        this.context = context;
        this.offset = 0;
    }

    @Override
    public boolean process() {
        boolean processed;
        TemplateFlowController flowController = this.getFlowController();
        if (flowController != null && flowController.stopProcessing) {
            return false;
        }
        if (this.offset == 0) {
            this.prepareProcessing();
        }
        Model model = this.getInnerModel();
        this.offset += model.process(this.getProcessorTemplateHandler(), this.offset, flowController);
        boolean bl = processed = flowController == null || this.offset == model.queueSize && !flowController.stopProcessing;
        if (processed) {
            this.context.decreaseLevel();
        }
        return processed;
    }
}

