/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.onmonit;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import io.jenkins.plugins.onmonit.LauncherProvider;
import io.jenkins.plugins.onmonit.Messages;
import io.jenkins.plugins.onmonit.MonitoringAction;
import io.jenkins.plugins.onmonit.ONMonitConfig;
import io.jenkins.plugins.onmonit.ONTemplating;
import io.jenkins.plugins.onmonit.RemoteNodeExporterProcess;
import io.jenkins.plugins.onmonit.RemoteNodeExporterProcessFactory;
import io.jenkins.plugins.onmonit.RemoteOtelContribProcess;
import io.jenkins.plugins.onmonit.RemoteOtelContribProcessFactory;
import io.jenkins.plugins.onmonit.util.AvailablePort;
import io.jenkins.plugins.onmonit.util.AvailablePortRetriever;
import io.jenkins.plugins.onmonit.util.ComputerInfo;
import io.jenkins.plugins.onmonit.util.RemoteComputerInfoRetriever;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public class ONMonitoringStepExecution
extends StepExecution
implements LauncherProvider {
    private static final long serialVersionUID = 1L;
    private int port;
    private boolean debug;
    private boolean launchCollector;
    private String dashboardUrl;
    private String neAdditionalOptions;
    private String ocAdditionalOptions;
    private String neCookie;
    private String ocCookie;
    private static ONTemplating templating = new ONTemplating();
    private transient RemoteNodeExporterProcess nodeExporter = null;
    private transient RemoteOtelContribProcess otelContrib = null;

    ONMonitoringStepExecution(StepContext context, int port, boolean debug, boolean launchCollector, String dashboardUrl, String neAdditionalOptions, String ocAdditionalOptions) {
        super(context);
        this.port = port;
        this.debug = debug;
        this.launchCollector = launchCollector;
        this.dashboardUrl = dashboardUrl;
        this.neAdditionalOptions = neAdditionalOptions;
        this.ocAdditionalOptions = ocAdditionalOptions;
        this.neCookie = UUID.randomUUID().toString();
        this.ocCookie = UUID.randomUUID().toString();
    }

    public boolean start() throws Exception {
        StepContext context = this.getContext();
        try {
            this.initRemoteProcesses();
            this.addActionOnce();
        }
        catch (Exception e) {
            this.getListener().getLogger().println(Messages.ONMonitoringStep_CouldNotStartProcesses());
            this.cleanUp();
            throw e;
        }
        context.newBodyInvoker().withCallback((BodyExecutionCallback)new Callback(this)).start();
        return false;
    }

    public void stop(@NonNull Throwable cause) throws Exception {
        try {
            this.cleanUp();
        }
        finally {
            super.stop(cause);
        }
    }

    public void onResume() {
        super.onResume();
        try {
            this.cleanUp();
            this.initRemoteProcesses();
        }
        catch (InterruptedException e) {
            this.getContext().onFailure((Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception x) {
            this.getContext().onFailure((Throwable)x);
            try {
                x.printStackTrace(this.getListener().getLogger());
                this.getListener().getLogger().println(Messages.ONMonitoringStep_CouldNotStartProcesses());
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static FilePath tempDir(FilePath ws) throws IOException, InterruptedException {
        FilePath tmpDir = WorkspaceList.tempDir((FilePath)ws);
        if (tmpDir == null) {
            throw new IOException("Could not create a tempDirectory in " + String.valueOf(ws));
        }
        tmpDir.mkdirs();
        return tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRemoteProcesses() throws IOException, InterruptedException {
        AvailablePort usedPort;
        StringWriter sw;
        TaskListener listener = this.getListener();
        if (!this.launchCollector) {
            listener.getLogger().println("[on-monit] Skipping launch of node_exporter and otel-contrib processes.");
            return;
        }
        Run<?, ?> build = this.getBuild();
        FilePath workspace = this.getWorkspace();
        Launcher launcher = this.getLauncher();
        ComputerInfo info = RemoteComputerInfoRetriever.getRemoteInfo(launcher);
        Semaphore portSync = AvailablePortRetriever.getSyncOjbectForLauncher(launcher);
        LinkedHashMap<String, Throwable> faults = new LinkedHashMap<String, Throwable>();
        listener.getLogger().println("[on-monit] Detected agent info: " + String.valueOf(info));
        listener.getLogger().println("[on-monit] Looking for node_exporter implementation...");
        for (Object factory : Jenkins.get().getExtensionList(RemoteNodeExporterProcessFactory.class)) {
            if (!((RemoteNodeExporterProcessFactory)factory).isSupported(launcher, listener, info)) continue;
            try {
                listener.getLogger().println("[on-monit]   " + ((RemoteNodeExporterProcessFactory)factory).getDisplayName());
                this.nodeExporter = ((RemoteNodeExporterProcessFactory)factory).create(this, listener, info, ONMonitoringStepExecution.tempDir(workspace), this.neCookie, this.getEffectiveNeAdditionalOptions(), this.debug);
                break;
            }
            catch (Throwable t) {
                faults.put(((RemoteNodeExporterProcessFactory)factory).getDisplayName(), t);
            }
        }
        listener.getLogger().println("[on-monit] Looking for otel-contrib implementation...");
        for (Object factory : Jenkins.get().getExtensionList(RemoteOtelContribProcessFactory.class)) {
            if (!((RemoteOtelContribProcessFactory)factory).isSupported(launcher, listener, info)) continue;
            try {
                listener.getLogger().println("[on-monit]   " + ((RemoteOtelContribProcessFactory)factory).getDisplayName());
                this.otelContrib = ((RemoteOtelContribProcessFactory)factory).create(this, listener, info, ONMonitoringStepExecution.tempDir(workspace), this.ocCookie, this.getEffectiveOcAdditionalOptions(), this.debug);
                break;
            }
            catch (Throwable t) {
                faults.put(((RemoteOtelContribProcessFactory)factory).getDisplayName(), t);
            }
        }
        if (this.nodeExporter == null) {
            listener.getLogger().println("[on-monit] FATAL: Could not find a suitable node_exporter provider");
            listener.getLogger().println("[on-monit] Diagnostic report");
            for (Map.Entry fault : faults.entrySet()) {
                listener.getLogger().println("[on-monit] * " + (String)fault.getKey());
                sw = new StringWriter();
                ((Throwable)fault.getValue()).printStackTrace(new PrintWriter(sw));
                for (String line : StringUtils.split((String)sw.toString(), (String)"\n")) {
                    listener.getLogger().println("[on-monit]     " + line);
                }
            }
            throw new RuntimeException("[on-monit] Could not find a suitable node_exporter provider.");
        }
        if (this.otelContrib == null) {
            listener.getLogger().println("[on-monit] FATAL: Could not find a suitable otel-contrib provider");
            listener.getLogger().println("[on-monit] Diagnostic report");
            for (Map.Entry fault : faults.entrySet()) {
                listener.getLogger().println("[on-monit] * " + (String)fault.getKey());
                sw = new StringWriter();
                ((Throwable)fault.getValue()).printStackTrace(new PrintWriter(sw));
                for (String line : StringUtils.split((String)sw.toString(), (String)"\n")) {
                    listener.getLogger().println("[on-monit]     " + line);
                }
            }
            throw new RuntimeException("[on-monit] Could not find a suitable otel-contrib provider.");
        }
        try {
            portSync.acquire();
            usedPort = AvailablePortRetriever.getAvailablePort(launcher, this.port, this.port + 100);
            listener.getLogger().println("[on-monit] node_exporter will listen on " + usedPort.getPort());
            this.nodeExporter.start(listener, usedPort.getPort());
        }
        finally {
            portSync.release();
        }
        if (templating == null) {
            throw new NullPointerException("templating is null");
        }
        if (build == null) {
            throw new NullPointerException("build is null");
        }
        String config = templating.renderTemplate(templating.getJobContext(build, build.getEnvironment(listener), usedPort.getPort()));
        this.otelContrib.start(listener, config);
        listener.getLogger().println(Messages.ONMonitoringStep_Started());
    }

    private String getEffectiveNeAdditionalOptions() {
        return StringUtils.isNotBlank((String)this.neAdditionalOptions) ? this.neAdditionalOptions : ONMonitConfig.get().getNeDefaultAdditionalOptions();
    }

    private String getEffectiveOcAdditionalOptions() {
        return StringUtils.isNotBlank((String)this.ocAdditionalOptions) ? this.ocAdditionalOptions : ONMonitConfig.get().getOcDefaultAdditionalOptions();
    }

    private void addActionOnce() throws IOException, InterruptedException {
        TaskListener listener = this.getListener();
        Run<?, ?> build = this.getBuild();
        EnvVars environment = build.getEnvironment(listener);
        ONTemplating.UrlContext urlContext = templating.getUrlContext(environment);
        build.addOrReplaceAction((Action)new MonitoringAction(urlContext, this.dashboardUrl));
    }

    private void cleanUp() throws Exception {
        HashMap<String, String> neCookieEnv;
        if (!this.launchCollector) {
            return;
        }
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        if (this.nodeExporter != null) {
            this.nodeExporter.stop(listener);
            this.nodeExporter = null;
        } else {
            neCookieEnv = new HashMap<String, String>();
            neCookieEnv.put("_JENKINS_PM_NODE_EXPORTER_COOKIE", this.neCookie);
            this.getLauncher().kill(neCookieEnv);
        }
        if (this.otelContrib != null) {
            this.otelContrib.stop(listener);
            this.otelContrib = null;
        } else {
            neCookieEnv = new HashMap();
            neCookieEnv.put("_JENKINS_PM_OTEL_COLLECTOR_COOKIE", this.ocCookie);
            this.getLauncher().kill(neCookieEnv);
        }
        listener.getLogger().println(Messages.ONMonitoringStep_Stopped());
    }

    @Override
    public Launcher getLauncher() throws IOException, InterruptedException {
        return (Launcher)this.getContext().get(Launcher.class);
    }

    public TaskListener getListener() throws IOException, InterruptedException {
        return (TaskListener)this.getContext().get(TaskListener.class);
    }

    public Run<?, ?> getBuild() throws IOException, InterruptedException {
        return (Run)this.getContext().get(Run.class);
    }

    public FilePath getWorkspace() throws IOException, InterruptedException {
        return (FilePath)this.getContext().get(FilePath.class);
    }

    private static class Callback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 1L;
        private final ONMonitoringStepExecution execution;

        Callback(ONMonitoringStepExecution execution) {
            this.execution = execution;
        }

        protected void finished(StepContext context) throws Exception {
            this.execution.cleanUp();
        }
    }
}

