/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.pipeline;

import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.plugins.openstack.compute.JCloudsCloud;
import jenkins.plugins.openstack.compute.JCloudsSlaveTemplate;
import jenkins.plugins.openstack.compute.ServerScope;
import jenkins.plugins.openstack.compute.internal.DestroyMachine;
import jenkins.plugins.openstack.compute.internal.Openstack;
import org.jenkinsci.plugins.resourcedisposer.AsyncResourceDisposer;
import org.jenkinsci.plugins.resourcedisposer.Disposable;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.openstack4j.model.compute.Server;

@Restricted(value={NoExternalUse.class})
public class SimplifiedServer
implements Serializable {
    private static final long serialVersionUID = 860084023141474202L;
    @CheckForNull
    private Server srv;
    @Nonnull
    private String cloud;
    @Nonnull
    private String template;
    @Nonnull
    private String scope;

    public SimplifiedServer(@Nonnull String cloud, @Nonnull String template, @Nonnull String scope) {
        this.template = template;
        this.cloud = cloud;
        this.scope = scope;
        ServerScope serverscope = ServerScope.parse(scope);
        JCloudsCloud jcl = JCloudsCloud.getByName(cloud);
        JCloudsSlaveTemplate t = jcl.getTemplate(template);
        if (t == null) {
            throw new IllegalArgumentException("Invalid template: " + template);
        }
        this.srv = t.provisionServer(serverscope, null);
    }

    @Whitelisted
    public void destroy() {
        if (this.srv == null) {
            return;
        }
        DestroyMachine dm = new DestroyMachine(this.cloud, this.srv.getId());
        AsyncResourceDisposer.get().dispose(new Disposable[]{dm});
        this.srv = null;
    }

    @Whitelisted
    public String getAddress() {
        if (this.srv == null) {
            return null;
        }
        return Openstack.getAccessIpAddress(this.srv);
    }

    @Whitelisted
    public String getStatus() {
        return this.srv != null ? this.srv.getStatus().name() : null;
    }

    @Whitelisted
    public String getId() {
        return this.srv != null ? this.srv.getId() : null;
    }
}

