/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.pipeline;

import hudson.Extension;
import hudson.Util;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.openstack.compute.JCloudsCloud;
import jenkins.plugins.openstack.compute.JCloudsSlaveTemplate;
import jenkins.plugins.openstack.compute.ServerScope;
import jenkins.plugins.openstack.pipeline.SimplifiedServer;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Restricted(value={NoExternalUse.class})
public class OpenStackMachineStep
extends Step {
    @Nonnull
    private String cloud = "";
    @Nonnull
    private String template = "";
    @Nonnull
    private String scope = "run";

    @DataBoundConstructor
    public OpenStackMachineStep() {
    }

    @DataBoundSetter
    public void setCloud(@Nonnull String cloud) {
        this.cloud = cloud;
    }

    @DataBoundSetter
    public void setTemplate(@Nonnull String template) {
        this.template = template;
    }

    @DataBoundSetter
    public void setScope(@CheckForNull String scope) {
        if (scope != null) {
            if ("run".equals(scope) || scope.startsWith("unlimited:")) {
                this.scope = scope;
            } else {
                throw new IllegalArgumentException("Invalid scope: " + scope);
            }
        }
    }

    @Nonnull
    public String getCloud() {
        return this.cloud;
    }

    @Nonnull
    public String getTemplate() {
        return this.template;
    }

    @Nonnull
    public String getScope() {
        return this.scope;
    }

    public StepExecution start(StepContext context) throws Exception {
        if (this.scope.equals("run")) {
            this.scope = new ServerScope.Build((Run)context.get(Run.class)).getValue();
        }
        ServerScope.parse(this.scope);
        return new Execution(this, context);
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<SimplifiedServer> {
        private static final long serialVersionUID = -1471755378664792632L;
        @Nonnull
        private final String cloud;
        @Nonnull
        private final String template;
        @Nonnull
        private final String scope;

        Execution(OpenStackMachineStep step, StepContext context) {
            super(context);
            this.cloud = step.cloud;
            this.template = step.template;
            this.scope = step.scope;
        }

        protected SimplifiedServer run() throws Exception {
            return new SimplifiedServer(this.cloud, this.template, this.scope);
        }
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "openstackMachine";
        }

        public String getDisplayName() {
            return "Cloud instances provisioning";
        }

        @RequirePOST
        public ListBoxModel doFillCloudItems() {
            ListBoxModel r = new ListBoxModel();
            r.add("", "");
            Hudson.CloudList clouds = Jenkins.get().clouds;
            for (Cloud cloud : clouds) {
                if (!(cloud instanceof JCloudsCloud)) continue;
                r.add(cloud.getDisplayName(), cloud.getDisplayName());
            }
            return r;
        }

        @RequirePOST
        public ListBoxModel doFillTemplateItems(@QueryParameter String cloud) {
            cloud = Util.fixEmpty((String)cloud);
            ListBoxModel r = new ListBoxModel();
            for (Cloud cl : Jenkins.get().clouds) {
                if (!cl.getDisplayName().equals(cloud) || !(cl instanceof JCloudsCloud)) continue;
                for (JCloudsSlaveTemplate template : ((JCloudsCloud)cl).getTemplates()) {
                    r.add(template.getName());
                }
            }
            return r;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }
    }
}

