/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute.slaveopts;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.trilead.ssh2.Connection;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Node;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.plugins.sshslaves.verifiers.NonVerifyingKeyVerificationStrategy;
import hudson.plugins.sshslaves.verifiers.SshHostKeyVerificationStrategy;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.JNLPLauncher;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.openstack.compute.JCloudsCloud;
import jenkins.plugins.openstack.compute.JCloudsSlave;
import jenkins.plugins.openstack.compute.SlaveOptions;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Restricted(value={NoExternalUse.class})
public abstract class LauncherFactory
extends AbstractDescribableImpl<LauncherFactory>
implements Serializable {
    private static final long serialVersionUID = -8322868020681278525L;
    private static final Logger LOGGER = Logger.getLogger(LauncherFactory.class.getName());

    public abstract ComputerLauncher createLauncher(@Nonnull JCloudsSlave var1) throws IOException;

    @CheckForNull
    public abstract String isWaitingFor(@Nonnull JCloudsSlave var1) throws JCloudsCloud.ProvisioningFailedException;

    public void onNodeTerminated() {
    }

    public static final class Unspecified
    extends LauncherFactory {
        private static final long serialVersionUID = -2723193057734405816L;

        private Unspecified() {
        }

        @Override
        public ComputerLauncher createLauncher(@Nonnull JCloudsSlave slave) {
            throw new UnsupportedOperationException();
        }

        @Override
        @CheckForNull
        public String isWaitingFor(@Nonnull JCloudsSlave slave) {
            throw new UnsupportedOperationException();
        }

        @Extension(ordinal=1.7976931348623157E308)
        public static final class Desc
        extends Descriptor<LauncherFactory> {
            @Nonnull
            public String getDisplayName() {
                return "Inherit / Override later";
            }

            public LauncherFactory newInstance(StaplerRequest req, @Nonnull JSONObject formData) {
                return null;
            }
        }
    }

    public static final class JNLP
    extends LauncherFactory {
        private static final long serialVersionUID = -1112849796889317240L;
        public static final LauncherFactory JNLP = new JNLP();
        private transient boolean terminated = false;

        @DataBoundConstructor
        public JNLP() {
        }

        @Override
        public ComputerLauncher createLauncher(@Nonnull JCloudsSlave slave) throws IOException {
            this.terminated = false;
            Jenkins.get().addNode((Node)slave);
            return new JNLPLauncher(false);
        }

        @Override
        @CheckForNull
        public String isWaitingFor(@Nonnull JCloudsSlave slave) {
            return this.terminated || slave.getChannel() != null ? null : "JNLP connection was not established yet";
        }

        @Override
        public void onNodeTerminated() {
            this.terminated = true;
            super.onNodeTerminated();
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass() == obj.getClass();
        }

        private Object readResolve() {
            return JNLP;
        }

        @Extension
        @Symbol(value={"jnlp"})
        public static final class Desc
        extends Descriptor<LauncherFactory> {
            public LauncherFactory newInstance(StaplerRequest req, @Nonnull JSONObject formData) {
                return JNLP;
            }
        }
    }

    public static final class SSH
    extends LauncherFactory {
        private static final long serialVersionUID = -1108865485314632255L;
        @Nonnull
        private final String credentialsId;
        @CheckForNull
        private final String javaPath;

        @Nonnull
        public String getCredentialsId() {
            return this.credentialsId;
        }

        @CheckForNull
        public String getJavaPath() {
            return this.javaPath;
        }

        @DataBoundConstructor
        public SSH(@Nonnull String credentialsId, String javaPath) {
            this.credentialsId = credentialsId;
            this.javaPath = Util.fixEmptyAndTrim((String)javaPath);
        }

        public SSH(@Nonnull String credentialsId) {
            this(credentialsId, null);
        }

        @Override
        public ComputerLauncher createLauncher(@Nonnull JCloudsSlave slave) {
            int maxNumRetries = 5;
            int retryWaitTime = 15;
            String publicAddress = Objects.requireNonNull(slave.getPublicAddress());
            SlaveOptions opts = slave.getSlaveOptions();
            Integer timeout = opts.getStartTimeout();
            timeout = timeout == null ? 0 : timeout / 1000;
            return new SSHLauncher(publicAddress, 22, this.credentialsId, opts.getJvmOptions(), this.javaPath, "", "", timeout, Integer.valueOf(maxNumRetries), Integer.valueOf(retryWaitTime), (SshHostKeyVerificationStrategy)new NonVerifyingKeyVerificationStrategy());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SSH ssh = (SSH)o;
            return Objects.equals(this.credentialsId, ssh.credentialsId) && Objects.equals(this.javaPath, ssh.javaPath);
        }

        public int hashCode() {
            return Objects.hash(this.credentialsId, this.javaPath);
        }

        public String toString() {
            return "LauncherFactory.SSH: credId:" + this.credentialsId + ", javaPath:" + this.javaPath;
        }

        @Override
        @CheckForNull
        public String isWaitingFor(@Nonnull JCloudsSlave slave) {
            String publicAddress;
            try {
                publicAddress = slave.getPublicAddress();
                if (publicAddress == null) {
                    throw new JCloudsCloud.ProvisioningFailedException("No accessible address provided for agent " + slave.getNodeName());
                }
            }
            catch (NoSuchElementException ex) {
                throw new JCloudsCloud.ProvisioningFailedException(ex.getMessage(), ex);
            }
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(publicAddress, 22), 500);
                socket.close();
                return null;
            }
            catch (ConnectException | NoRouteToHostException | SocketTimeoutException ex) {
                String msg = "SSH port at " + publicAddress + " not open (yet)";
                LOGGER.log(Level.FINEST, msg, ex);
                return msg;
            }
            catch (IOException ex) {
                String msg = "SSH port at " + publicAddress + " does not seem to respond correctly: " + ex.getMessage();
                LOGGER.log(Level.INFO, msg, ex);
                return msg;
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "SSH probe failed", ex);
                return null;
            }
        }

        @Extension
        @Symbol(value={"ssh"})
        public static final class Desc
        extends Descriptor<LauncherFactory> {
            @Restricted(value={DoNotUse.class})
            @RequirePOST
            public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup<?> context) {
                if (!(context instanceof AccessControlled ? (AccessControlled)context : Jenkins.get()).hasPermission(Computer.CONFIGURE)) {
                    return new ListBoxModel();
                }
                return new StandardUsernameListBoxModel().includeMatchingAs(ACL.SYSTEM2, context, StandardUsernameCredentials.class, Collections.singletonList(SSHLauncher.SSH_SCHEME), SSHAuthenticator.matcher(Connection.class)).includeEmptyValue();
            }
        }
    }
}

