/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute.slaveopts;

import hudson.Extension;
import hudson.RelativePath;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.plugins.openstack.compute.JCloudsCloud;
import jenkins.plugins.openstack.compute.OsAuthDescriptor;
import jenkins.plugins.openstack.compute.SlaveOptionsDescriptor;
import jenkins.plugins.openstack.compute.auth.OpenstackCredential;
import jenkins.plugins.openstack.compute.auth.OpenstackCredentials;
import jenkins.plugins.openstack.compute.internal.Openstack;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.openstack4j.api.Builders;
import org.openstack4j.api.exceptions.AuthenticationException;
import org.openstack4j.api.exceptions.ConnectionException;
import org.openstack4j.model.compute.BDMDestType;
import org.openstack4j.model.compute.BDMSourceType;
import org.openstack4j.model.compute.BlockDeviceMappingCreate;
import org.openstack4j.model.compute.Server;
import org.openstack4j.model.compute.builder.BlockDeviceMappingBuilder;
import org.openstack4j.model.compute.builder.ServerCreateBuilder;

@Restricted(value={NoExternalUse.class})
public abstract class BootSource
extends AbstractDescribableImpl<BootSource>
implements Serializable {
    private static final long serialVersionUID = -838838433829383008L;
    private static final Logger LOGGER = Logger.getLogger(BootSource.class.getName());
    private static final String OPENSTACK_BOOTSOURCE_KEY = "jenkins-boot-source";

    public void setServerBootSource(@Nonnull ServerCreateBuilder builder, @Nonnull Openstack os) throws JCloudsCloud.ProvisioningFailedException {
        builder.addMetadataItem(OPENSTACK_BOOTSOURCE_KEY, this.toString());
    }

    public void afterProvisioning(@Nonnull Server server, @Nonnull Openstack openstack) throws JCloudsCloud.ProvisioningFailedException {
    }

    public BootSourceDescriptor getDescriptor() {
        return (BootSourceDescriptor)super.getDescriptor();
    }

    protected String selectIdFromListAndLogProblems(List<String> matchingIds, String name, String pluralOfNameType) {
        String id;
        int size = matchingIds.size();
        if (size < 1) {
            LOGGER.info("NO " + pluralOfNameType + " match name '" + name + "'.");
            id = name;
        } else if (size == 1) {
            id = matchingIds.get(0);
        } else {
            id = matchingIds.get(size - 1);
            LOGGER.warning("Ambiguity: " + size + " " + pluralOfNameType + " match name '" + name + "'. Using the most recent one: " + id);
        }
        return id;
    }

    public static abstract class BootSourceDescriptor
    extends OsAuthDescriptor<BootSource> {
        @Override
        public List<String> getAuthFieldsOffsets() {
            return Arrays.asList("../..", "../../..");
        }

        protected ListBoxModel makeListBoxModelOfAllNames(String existingValue, String endPointUrl, boolean ignoreSsl, String credentialsId, String zone, long cleanfreq) {
            ListBoxModel m = new ListBoxModel();
            String valueOrEmpty = Util.fixNull((String)existingValue);
            OpenstackCredential openstackCredential = OpenstackCredentials.getCredential(credentialsId);
            m.add((Object)new ListBoxModel.Option("None specified", "", valueOrEmpty.isEmpty()));
            try {
                if (BootSourceDescriptor.haveAuthDetails(endPointUrl, openstackCredential, zone)) {
                    Openstack openstack = Openstack.Factory.get(endPointUrl, ignoreSsl, openstackCredential, zone, cleanfreq);
                    List<String> values = this.listAllNames(openstack);
                    Iterator<String> iterator = values.iterator();
                    while (iterator.hasNext()) {
                        String value;
                        String displayText = value = iterator.next();
                        m.add(displayText, value);
                    }
                }
            }
            catch (FormValidation | AuthenticationException | ConnectionException ex) {
                LOGGER.log(Level.FINEST, "Openstack call failed", ex);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            }
            if (!BootSourceDescriptor.hasValue(m, valueOrEmpty)) {
                m.add(valueOrEmpty);
            }
            return m;
        }

        protected FormValidation checkNameMatchesOnlyOnce(String value, String endPointUrl1, String endPointUrl2, boolean ignoreSsl1, boolean ignoreSsl2, String credentialsId1, String credentialsId2, String zone1, String zone2, long cleanfreq1, long cleanfreq2) {
            List<String> matches;
            if (Util.fixEmpty((String)value) == null) {
                return SlaveOptionsDescriptor.REQUIRED;
            }
            String endPointUrl = BootSourceDescriptor.getDefault(endPointUrl1, endPointUrl2);
            String credentialsId = BootSourceDescriptor.getDefault(credentialsId1, credentialsId2);
            boolean ignoreSsl = ignoreSsl1 || ignoreSsl2;
            OpenstackCredential openstackCredential = OpenstackCredentials.getCredential(credentialsId);
            String zone = BootSourceDescriptor.getDefault(zone1, zone2);
            long cleanfreq = cleanfreq1 + cleanfreq2;
            if (!BootSourceDescriptor.haveAuthDetails(endPointUrl, openstackCredential, zone)) {
                return FormValidation.ok();
            }
            try {
                Openstack openstack = Openstack.Factory.get(endPointUrl, ignoreSsl, openstackCredential, zone, cleanfreq);
                matches = this.findMatchingIds(openstack, value);
            }
            catch (FormValidation | AuthenticationException | ConnectionException ex) {
                LOGGER.log(Level.FINEST, "Openstack call failed", ex);
                return FormValidation.warning((Throwable)ex, (String)"Unable to validate");
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                return FormValidation.warning((Throwable)ex, (String)"Unable to validate");
            }
            int numberOfMatches = matches.size();
            if (numberOfMatches < 1) {
                return FormValidation.error((String)"Not found");
            }
            if (numberOfMatches > 1) {
                return FormValidation.warning((String)"Multiple matching results");
            }
            return FormValidation.ok();
        }

        @Nonnull
        public abstract List<String> findMatchingIds(Openstack var1, String var2);

        public abstract List<String> listAllNames(Openstack var1);
    }

    public static final class Unspecified
    extends BootSource {
        private static final long serialVersionUID = -2723193057734405815L;

        private Unspecified() {
        }

        @Extension(ordinal=1.7976931348623157E308)
        public static final class Desc
        extends Descriptor<BootSource> {
            @Nonnull
            public String getDisplayName() {
                return "Inherit / Override later";
            }

            public BootSource newInstance(StaplerRequest req, @Nonnull JSONObject formData) throws Descriptor.FormException {
                return null;
            }
        }
    }

    public static final class VolumeSnapshot
    extends BootSource {
        private static final long serialVersionUID = 1629434277902240395L;
        private static final String OPENSTACK_BOOTSOURCE_VOLUMESNAPSHOT_ID_KEY = "jenkins-boot-volumesnapshot-id";
        private static final String OPENSTACK_BOOTSOURCE_VOLUMESNAPSHOT_DESC_KEY = "jenkins-boot-volumesnapshot-description";
        @Nonnull
        private final String name;

        @DataBoundConstructor
        public VolumeSnapshot(@Nonnull String name) {
            Objects.requireNonNull(name, "Volume snapshot name missing");
            this.name = name;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        public void setServerBootSource(@Nonnull ServerCreateBuilder builder, @Nonnull Openstack os) {
            super.setServerBootSource(builder, os);
            List<String> matchingIds = this.getDescriptor().findMatchingIds(os, this.name);
            String id = this.selectIdFromListAndLogProblems(matchingIds, this.name, "VolumeSnapshots");
            String volumeSnapshotDescriptionOrNull = null;
            try {
                volumeSnapshotDescriptionOrNull = os.getVolumeSnapshotDescription(id);
            }
            catch (RuntimeException ex) {
                LOGGER.warning("Unable to get volume " + id + " description: " + ex.getMessage());
            }
            BlockDeviceMappingBuilder volumeBuilder = Builders.blockDeviceMapping().sourceType(BDMSourceType.SNAPSHOT).destinationType(BDMDestType.VOLUME).uuid(id).deleteOnTermination(true).bootIndex(0);
            builder.blockDevice((BlockDeviceMappingCreate)volumeBuilder.build());
            builder.addMetadataItem(OPENSTACK_BOOTSOURCE_VOLUMESNAPSHOT_ID_KEY, id);
            if (volumeSnapshotDescriptionOrNull != null && !volumeSnapshotDescriptionOrNull.isEmpty()) {
                builder.addMetadataItem(OPENSTACK_BOOTSOURCE_VOLUMESNAPSHOT_DESC_KEY, volumeSnapshotDescriptionOrNull);
            }
        }

        @Override
        public void afterProvisioning(@Nonnull Server server, @Nonnull Openstack openstack) {
            List volumeIds = server.getOsExtendedVolumesAttached();
            String instanceId = server.getId();
            String instanceName = server.getName();
            Map instanceMetaData = server.getMetadata();
            String instanceVolumeSnapshotId = instanceMetaData == null ? null : (String)instanceMetaData.get(OPENSTACK_BOOTSOURCE_VOLUMESNAPSHOT_ID_KEY);
            int i = 0;
            String newVolumeDescription = "For " + instanceName + " (" + instanceId + "), from VolumeSnapshot " + this.name + (String)(instanceVolumeSnapshotId == null ? "" : " (" + instanceVolumeSnapshotId + ")") + ".";
            for (String volumeId : volumeIds) {
                String newVolumeName = instanceName + "[" + i++ + "]";
                try {
                    openstack.setVolumeNameAndDescription(volumeId, newVolumeName, newVolumeDescription);
                }
                catch (Openstack.ActionFailed ex) {
                    LOGGER.warning("Unable to set volume " + volumeId + " name and description: " + ex.getMessage());
                }
            }
        }

        public String toString() {
            return "VolumeSnapshot " + this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VolumeSnapshot that = (VolumeSnapshot)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Extension
        @Symbol(value={"volumeSnapshot"})
        public static final class Desc
        extends BootSourceDescriptor {
            @Nonnull
            public String getDisplayName() {
                return "Volume Snapshot";
            }

            @Override
            @Nonnull
            public List<String> findMatchingIds(Openstack openstack, String nameOrId) {
                return openstack.getVolumeSnapshotIdsFor(nameOrId);
            }

            @Override
            @Nonnull
            public List<String> listAllNames(Openstack openstack) {
                return new ArrayList<String>(openstack.getVolumeSnapshots().keySet());
            }

            @Restricted(value={DoNotUse.class})
            @OsAuthDescriptor.InjectOsAuth
            @RequirePOST
            public ListBoxModel doFillNameItems(@QueryParameter String name, @QueryParameter String endPointUrl, @QueryParameter boolean ignoreSsl, @QueryParameter String credentialsId, @QueryParameter String zone, @QueryParameter long cleanfreq) {
                return this.makeListBoxModelOfAllNames(name, endPointUrl, ignoreSsl, credentialsId, zone, cleanfreq);
            }

            @Restricted(value={DoNotUse.class})
            @RequirePOST
            public FormValidation doCheckName(@QueryParameter String value, @RelativePath(value="../..") @QueryParameter(value="endPointUrl") String endPointUrlCloud, @RelativePath(value="../../..") @QueryParameter(value="endPointUrl") String endPointUrlTemplate, @RelativePath(value="../..") @QueryParameter(value="ignoreSsl") boolean ignoreSslCloud, @RelativePath(value="../../..") @QueryParameter(value="ignoreSsl") boolean ignoreSslTemplate, @RelativePath(value="../..") @QueryParameter(value="credentialsId") String credentialsIdCloud, @RelativePath(value="../../..") @QueryParameter(value="credentialsId") String credentialsIdTemplate, @RelativePath(value="../..") @QueryParameter(value="zone") String zoneCloud, @RelativePath(value="../../..") @QueryParameter(value="zone") String zoneTemplate, @RelativePath(value="../..") @QueryParameter(value="cleanfreq") long cleanFreqCloud, @RelativePath(value="../../..") @QueryParameter(value="cleanfreq") long cleanFreqTemplate) {
                return this.checkNameMatchesOnlyOnce(value, endPointUrlCloud, endPointUrlTemplate, ignoreSslCloud, ignoreSslTemplate, credentialsIdCloud, credentialsIdTemplate, zoneCloud, zoneTemplate, cleanFreqCloud, cleanFreqTemplate);
            }
        }
    }

    public static final class VolumeFromImage
    extends Image {
        private static final long serialVersionUID = 3932407339481241514L;
        private static final String OPENSTACK_BOOTSOURCE_VOLUME_FROM_IMAGE_ID_KEY = "jenkins-boot-volumefromimage-id";
        private final int volumeSize;

        public int getVolumeSize() {
            return this.volumeSize;
        }

        @DataBoundConstructor
        public VolumeFromImage(@Nonnull String name, int volumeSize) {
            super(name);
            if (volumeSize <= 0) {
                throw new IllegalArgumentException("Volume size must be positive, got " + volumeSize);
            }
            this.volumeSize = volumeSize;
        }

        @Override
        public void setServerBootSource(@Nonnull ServerCreateBuilder builder, @Nonnull Openstack os) throws JCloudsCloud.ProvisioningFailedException {
            super.setServerBootSource(builder, os);
            List<String> matchingIds = this.getDescriptor().findMatchingIds(os, this.name);
            String id = this.selectIdFromListAndLogProblems(matchingIds, this.name, "Images");
            BlockDeviceMappingBuilder volumeBuilder = Builders.blockDeviceMapping().sourceType(BDMSourceType.IMAGE).destinationType(BDMDestType.VOLUME).uuid(id).volumeSize(Integer.valueOf(this.volumeSize)).deleteOnTermination(true).bootIndex(0);
            builder.blockDevice((BlockDeviceMappingCreate)volumeBuilder.build());
            builder.addMetadataItem(OPENSTACK_BOOTSOURCE_VOLUME_FROM_IMAGE_ID_KEY, id);
        }

        @Override
        public String toString() {
            return "Volume from Image " + this.name + " (" + this.volumeSize + "GB)";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!super.equals(o)) {
                return false;
            }
            VolumeFromImage that = (VolumeFromImage)o;
            return this.volumeSize == that.volumeSize;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.volumeSize, super.hashCode());
        }

        @Extension
        @Symbol(value={"volumeFromImage"})
        public static final class VFIDesc
        extends Image.Desc {
            @Override
            @Nonnull
            public String getDisplayName() {
                return "Volume from Image";
            }
        }
    }

    public static class Image
    extends BootSource {
        private static final long serialVersionUID = -8309975034351235331L;
        private static final String OPENSTACK_BOOTSOURCE_IMAGE_ID_KEY = "jenkins-boot-image-id";
        @Nonnull
        protected final String name;

        @DataBoundConstructor
        public Image(@Nonnull String name) {
            Objects.requireNonNull(name, "Image name missing");
            this.name = name;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        public void setServerBootSource(@Nonnull ServerCreateBuilder builder, @Nonnull Openstack os) throws JCloudsCloud.ProvisioningFailedException {
            super.setServerBootSource(builder, os);
            List<String> matchingIds = this.getDescriptor().findMatchingIds(os, this.name);
            String id = this.selectIdFromListAndLogProblems(matchingIds, this.name, "Images");
            builder.image(id);
            builder.addMetadataItem(OPENSTACK_BOOTSOURCE_IMAGE_ID_KEY, id);
        }

        public String toString() {
            return "Image " + this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Image image = (Image)o;
            return this.name.equals(image.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Extension
        @Symbol(value={"image"})
        public static class Desc
        extends BootSourceDescriptor {
            @Nonnull
            public String getDisplayName() {
                return "Image";
            }

            @Override
            @Nonnull
            public List<String> findMatchingIds(Openstack openstack, String nameOrId) {
                return openstack.getImageIdsFor(nameOrId);
            }

            @Override
            @Nonnull
            public List<String> listAllNames(Openstack openstack) {
                return new ArrayList<String>(openstack.getImages().keySet());
            }

            @Restricted(value={DoNotUse.class})
            @OsAuthDescriptor.InjectOsAuth
            @RequirePOST
            public ListBoxModel doFillNameItems(@QueryParameter String name, @QueryParameter String endPointUrl, @QueryParameter boolean ignoreSsl, @QueryParameter String credentialsId, @QueryParameter String zone, @QueryParameter long cleanfreq) {
                return this.makeListBoxModelOfAllNames(name, endPointUrl, ignoreSsl, credentialsId, zone, cleanfreq);
            }

            @Restricted(value={DoNotUse.class})
            @RequirePOST
            public FormValidation doCheckName(@QueryParameter String value, @RelativePath(value="../..") @QueryParameter(value="endPointUrl") String endPointUrlCloud, @RelativePath(value="../../..") @QueryParameter(value="endPointUrl") String endPointUrlTemplate, @RelativePath(value="../..") @QueryParameter(value="ignoreSsl") boolean ignoreSslCloud, @RelativePath(value="../../..") @QueryParameter(value="ignoreSsl") boolean ignoreSslTemplate, @RelativePath(value="../..") @QueryParameter(value="credentialsId") String credentialsIdCloud, @RelativePath(value="../../..") @QueryParameter(value="credentialsId") String credentialsIdTemplate, @RelativePath(value="../..") @QueryParameter(value="zone") String zoneCloud, @RelativePath(value="../../..") @QueryParameter(value="zone") String zoneTemplate, @RelativePath(value="../..") @QueryParameter(value="cleanfreq") long cleanFreqCloud, @RelativePath(value="../../..") @QueryParameter(value="cleanfreq") long cleanFreqTemplate) {
                return this.checkNameMatchesOnlyOnce(value, endPointUrlCloud, endPointUrlTemplate, ignoreSslCloud, ignoreSslTemplate, credentialsIdCloud, credentialsIdTemplate, zoneCloud, zoneTemplate, cleanFreqCloud, cleanFreqTemplate);
            }
        }
    }
}

