/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute.internal;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class TokenGroup {
    public static final String STRIP_ALL_WHITESPACE = null;

    @Nonnull
    public static List<String> from(@Nonnull String input, char delim) {
        List<String> strings = TokenGroup.breakInput(input, new char[]{delim});
        ArrayList<String> ret = new ArrayList<String>(strings.size() / 2 + 1);
        for (int i = 0; i < strings.size(); i += 2) {
            ret.add(TokenGroup.clean(strings.get(i)));
        }
        return ret;
    }

    @Nonnull
    public static List<List<String>> from(@Nonnull String input, char delim1, char delim2) {
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        List<String> strings = TokenGroup.breakInput(input, new char[]{delim1, delim2});
        ArrayList<String> chunks = new ArrayList<String>();
        for (int i = 0; i < strings.size(); i += 2) {
            String token = strings.get(i);
            chunks.add(TokenGroup.clean(token));
            if (i + 1 == strings.size()) break;
            char delimiter = strings.get(i + 1).charAt(0);
            if (delimiter != delim1) continue;
            ret.add(chunks);
            chunks = new ArrayList();
        }
        ret.add(chunks);
        return ret;
    }

    private static String clean(String in) {
        return StringUtils.strip((String)in, (String)STRIP_ALL_WHITESPACE);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nonnull
    private static List<String> breakInput(String input, char[] delims) {
        ArrayList<Integer> delimiters = new ArrayList<Integer>();
        for (char delim : delims) {
            delimiters.add(Integer.valueOf(delim));
        }
        ArrayList<String> fields = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        boolean inQuotes = false;
        boolean escaped = false;
        int[] nArray = input.codePoints().toArray();
        int n = nArray.length;
        int n2 = 0;
        while (true) {
            block10: {
                block9: {
                    int c;
                    block7: {
                        block8: {
                            if (n2 >= n) {
                                fields.add(token.toString());
                                return fields;
                            }
                            c = nArray[n2];
                            if (c != 92) break block7;
                            if (!escaped) break block8;
                            token.append('\\');
                            break block9;
                        }
                        escaped = true;
                        break block10;
                    }
                    if (c == 34 && !escaped) {
                        inQuotes = !inQuotes;
                    } else if (delimiters.contains(c) && !inQuotes) {
                        fields.add(token.toString());
                        fields.add(String.valueOf((char)c));
                        token.setLength(0);
                    } else {
                        token.append((char)c);
                    }
                }
                escaped = false;
            }
            ++n2;
        }
    }
}

