/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute.internal;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.openstack4j.model.compute.Server;

@Restricted(value={NoExternalUse.class})
public class FipScope {
    static final int MAX_DESCRIPTION_LENGTH = 250;

    @Nonnull
    public static String getDescription(@Nonnull String url, @Nonnull String identity, @Nonnull Server server) {
        String description = "{ 'jenkins-instance': '" + url + "', 'jenkins-identity': '" + identity + "', 'jenkins-scope': 'server:" + server.getId() + "' }";
        if (description.length() < 250) {
            return description;
        }
        return "{ 'jenkins-identity': '" + identity + "', 'jenkins-scope': 'server:" + server.getId() + "' }";
    }

    @CheckForNull
    public static String getServerId(@Nonnull String url, @Nonnull String identity, @CheckForNull String description) {
        String scope = FipScope.getScopeString(url, identity, description);
        if (scope == null) {
            return null;
        }
        if (!scope.startsWith("server:")) {
            throw new IllegalArgumentException("Unknown scope of '" + scope + " description " + description);
        }
        return scope.substring(7);
    }

    @CheckForNull
    private static String getScopeString(@Nonnull String url, @Nonnull String identity, @CheckForNull String description) {
        try {
            JSONObject jsonObject = JSONObject.fromObject((Object)description);
            String attachedIdentity = jsonObject.optString("jenkins-identity", null);
            String attachedUrl = jsonObject.optString("jenkins-instance", null);
            if (attachedIdentity == null && attachedUrl == null) {
                return null;
            }
            if (attachedIdentity != null && !Objects.equals(attachedIdentity, identity)) {
                return null;
            }
            if (attachedUrl != null && !Objects.equals(attachedUrl, url)) {
                return null;
            }
            return jsonObject.getString("jenkins-scope");
        }
        catch (JSONException ex) {
            return null;
        }
    }
}

