/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute.internal;

import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import jenkins.plugins.openstack.compute.JCloudsCloud;
import jenkins.plugins.openstack.compute.internal.Openstack;
import org.jenkinsci.plugins.resourcedisposer.Disposable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.openstack4j.model.compute.Server;

@Restricted(value={NoExternalUse.class})
public final class DestroyMachine
implements Disposable {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final String cloudName;
    @Nonnull
    private final String nodeId;

    public DestroyMachine(@Nonnull String cloudName, @Nonnull String nodeId) {
        this.cloudName = cloudName;
        this.nodeId = nodeId;
    }

    @Nonnull
    public Disposable.State dispose() {
        Server server;
        JCloudsCloud cloud;
        try {
            cloud = JCloudsCloud.getByName(this.cloudName);
        }
        catch (IllegalArgumentException ex) {
            throw new CloudGoneException("Cloud " + this.cloudName + " does no longer exists", ex);
        }
        Openstack os = cloud.getOpenstack();
        try {
            server = os.getServerById(this.nodeId);
        }
        catch (NoSuchElementException ex) {
            return Disposable.State.PURGED;
        }
        os.destroyServer(server);
        return Disposable.State.PURGED;
    }

    @Nonnull
    public String getDisplayName() {
        return "Openstack " + this.cloudName + " machine " + this.nodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DestroyMachine that = (DestroyMachine)o;
        if (!this.cloudName.equals(that.cloudName)) {
            return false;
        }
        return this.nodeId.equals(that.nodeId);
    }

    public int hashCode() {
        int result = this.cloudName.hashCode();
        result = 31 * result + this.nodeId.hashCode();
        return result;
    }

    public static final class CloudGoneException
    extends RuntimeException {
        private static final long serialVersionUID = 2390778289323999027L;

        public CloudGoneException(String message, IllegalArgumentException ex) {
            super(message, ex);
        }
    }
}

