/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute.auth;

import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.NameWith;
import com.cloudbees.plugins.credentials.common.PasswordCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.Util;
import hudson.util.Secret;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.plugins.openstack.compute.auth.AbstractOpenstackCredential;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.openstack4j.api.client.IOSClientBuilder;
import org.openstack4j.model.common.Identifier;
import org.openstack4j.openstack.OSFactory;

@NameWith(value=NameProvider.class)
public class OpenstackCredentialv3
extends AbstractOpenstackCredential
implements StandardUsernamePasswordCredentials,
PasswordCredentials {
    private static final long serialVersionUID = -1868447356467542586L;
    private final String username;
    private final String userDomain;
    private final String projectName;
    private final String projectDomain;
    private final Secret password;

    @DataBoundConstructor
    public OpenstackCredentialv3(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @Nonnull String userName, @Nonnull String userDomain, @Nonnull String projectName, @Nonnull String projectDomain, @Nonnull String password) {
        this(scope, id, description, userName, userDomain, projectName, projectDomain, Secret.fromString((String)password));
    }

    public OpenstackCredentialv3(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @Nonnull String userName, @Nonnull String userDomain, @Nonnull String projectName, @Nonnull String projectDomain, @Nonnull Secret password) {
        super(scope, id, description);
        this.username = userName;
        this.userDomain = userDomain;
        this.projectName = projectName;
        this.projectDomain = projectDomain;
        this.password = password;
    }

    @Nonnull
    public Secret getPassword() {
        return this.password;
    }

    @Nonnull
    public IOSClientBuilder.V3 getBuilder(String endPointUrl) {
        Identifier projectDomainIdentifier = Identifier.byName((String)this.projectDomain);
        Identifier projectNameIdentifier = Identifier.byName((String)this.projectName);
        Identifier userDomainIdentifier = Identifier.byName((String)this.userDomain);
        return ((IOSClientBuilder.V3)OSFactory.builderV3().endpoint(endPointUrl)).credentials(this.username, this.getPassword().getPlainText(), userDomainIdentifier).scopeToProject(projectNameIdentifier, projectDomainIdentifier);
    }

    public String toString() {
        return "OpenstackCredentialv3{username='" + this.username + "', userDomain='" + this.userDomain + "', projectName='" + this.projectName + "', projectDomain='" + this.projectDomain + "'}";
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    @Nonnull
    public String getUserName() {
        return this.username;
    }

    public String getUserDomain() {
        return this.userDomain;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectDomain() {
        return this.projectDomain;
    }

    @Extension(ordinal=1.0)
    @Symbol(value={"openstackV3"})
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @Nonnull
        public String getDisplayName() {
            return "OpenStack auth v3";
        }
    }

    public static class NameProvider
    extends CredentialsNameProvider<OpenstackCredentialv3> {
        @Nonnull
        public String getName(@Nonnull OpenstackCredentialv3 c) {
            String description = Util.fixEmptyAndTrim((String)c.getDescription());
            return c.getProjectDomain() + ":" + c.getProjectName() + ":" + c.getUserDomain() + ":" + c.getUsername() + "/******" + (String)(description != null ? " (" + description + ")" : "");
        }
    }
}

