/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute.auth;

import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.NameWith;
import com.cloudbees.plugins.credentials.common.PasswordCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.Util;
import hudson.util.Secret;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.plugins.openstack.compute.auth.AbstractOpenstackCredential;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.openstack4j.api.client.IOSClientBuilder;
import org.openstack4j.openstack.OSFactory;

@NameWith(value=NameProvider.class)
public class OpenstackCredentialv2
extends AbstractOpenstackCredential
implements StandardUsernamePasswordCredentials,
PasswordCredentials {
    private static final long serialVersionUID = -2723193057734405814L;
    private final String tenant;
    private final String username;
    private final Secret password;

    @DataBoundConstructor
    public OpenstackCredentialv2(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @CheckForNull String tenant, @CheckForNull String username, @CheckForNull String password) {
        this(scope, id, description, tenant, username, Secret.fromString((String)password));
    }

    public OpenstackCredentialv2(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @CheckForNull String tenant, @CheckForNull String username, @CheckForNull Secret password) {
        super(scope, id, description);
        this.tenant = Util.fixEmptyAndTrim((String)tenant);
        this.username = Util.fixEmptyAndTrim((String)username);
        this.password = password;
    }

    @Nonnull
    public Secret getPassword() {
        return this.password;
    }

    @Nonnull
    public IOSClientBuilder.V2 getBuilder(String endPointUrl) {
        return ((IOSClientBuilder.V2)((IOSClientBuilder.V2)OSFactory.builderV2().endpoint(endPointUrl)).credentials(this.username, this.getPassword().getPlainText())).tenantName(this.tenant);
    }

    public String toString() {
        return "OpenstackCredentialv2{tenant='" + this.tenant + "', username='" + this.username + "'}";
    }

    public String getTenant() {
        return this.tenant;
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    @Extension(ordinal=1.0)
    @Symbol(value={"openstackV2"})
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @Nonnull
        public String getDisplayName() {
            return "OpenStack auth v2";
        }
    }

    public static class NameProvider
    extends CredentialsNameProvider<OpenstackCredentialv2> {
        @Nonnull
        public String getName(@Nonnull OpenstackCredentialv2 c) {
            String description = Util.fixEmptyAndTrim((String)c.getDescription());
            return c.getTenant() + ":" + c.getUsername() + "/******" + (String)(description != null ? " (" + description + ")" : "");
        }
    }
}

