/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute.auth;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.openstack.compute.auth.OpenstackCredential;
import org.springframework.security.core.Authentication;

public class OpenstackCredentials {
    @CheckForNull
    public static OpenstackCredential getCredential(@CheckForNull String credentialsId) {
        if (credentialsId == null) {
            return null;
        }
        List credentials = CredentialsProvider.lookupCredentialsInItemGroup(OpenstackCredential.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM2, Collections.emptyList());
        return (OpenstackCredential)CredentialsMatchers.firstOrNull((Iterable)credentials, (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public static void add(@Nonnull OpenstackCredential openstackCredential) {
        SystemCredentialsProvider.getInstance().getCredentials().add(openstackCredential);
    }

    public static void save() throws IOException {
        SystemCredentialsProvider.getInstance().save();
    }
}

