/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import hudson.Util;
import hudson.util.VariableResolver;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.openstack.compute.SlaveOptions;
import jenkins.slaves.JnlpAgentReceiver;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;

class UserDataVariableResolver
implements VariableResolver<String> {
    static final Map<String, Entry> STUB = new LinkedHashMap<String, Entry>();
    @Nonnull
    private final String rootUrl;
    @Nonnull
    private final String serverName;
    @Nonnull
    private final String labelString;
    @Nonnull
    private final String host;
    @Nonnull
    private final SlaveOptions opts;

    private static void stub(@Nonnull String name, @Nonnull String doc, @Nonnull ValueCalculator vc) {
        STUB.put(name, new Entry(name, doc, vc));
    }

    UserDataVariableResolver(@Nonnull String rootUrl, @Nonnull String serverName, @Nonnull String labelString, @Nonnull SlaveOptions opts) {
        String host;
        this.rootUrl = rootUrl;
        this.serverName = serverName;
        this.labelString = labelString;
        this.opts = opts;
        try {
            host = new URI(rootUrl).getHost();
        }
        catch (URISyntaxException ex) {
            host = rootUrl;
        }
        this.host = host;
    }

    public String resolve(@Nonnull String name) {
        Entry entry = STUB.get(name);
        if (entry == null) {
            return null;
        }
        return entry.vc.get(this);
    }

    static {
        UserDataVariableResolver.stub("SLAVE_JENKINS_HOME", "The 'Remote FS Root' for the agent.", r -> Util.fixNull((String)r.opts.getFsRoot()));
        UserDataVariableResolver.stub("SLAVE_JVM_OPTIONS", "The 'Custom JVM Options'.", r -> Util.fixNull((String)r.opts.getJvmOptions()));
        UserDataVariableResolver.stub("JENKINS_URL", "The URL of the Jenkins instance.", r -> r.rootUrl);
        UserDataVariableResolver.stub("SLAVE_JAR_URL", "The URL of the executable slave.jar.", r -> r.rootUrl + "jnlpJars/slave.jar");
        UserDataVariableResolver.stub("SLAVE_JNLP_URL", "The endpoint URL for the JNLP connection.", r -> r.rootUrl + "computer/" + Util.rawEncode((String)r.serverName) + "/slave-agent.jnlp");
        UserDataVariableResolver.stub("SLAVE_JNLP_SECRET", "The JNLP 'secret' key. This key authorizes to connect Jenkins agent process to a Jenkins computer. Note that referencing this in server user-data (and then using it to launch agent process) makes it exposed to any user or automation permitted to access the Jenkins agent (including running builds). Also, when OpenStack deployment uses metadata service, which it often does, it must be deployed in a way this is guaranteed not to leak. See <a href='https://wiki.openstack.org/wiki/OSSN/OSSN-0074'>OSSN-0074</a> for further details.", r -> Util.fixNull((String)JnlpAgentReceiver.SLAVE_SECRET.mac(r.serverName)));
        UserDataVariableResolver.stub("SLAVE_LABELS", "Labels of the node.", r -> r.labelString);
        UserDataVariableResolver.stub("AGENT_NAME", "Agent name", r -> r.serverName);
        UserDataVariableResolver.stub("JENKINS_INSTANCE_IDENTITY", "Jenkins instance identity. See <a href='https://wiki.jenkins.io/display/JENKINS/Instance+Identity'>Instance Identity</a>", r -> Util.fixNull((String)Base64.getEncoder().encodeToString(InstanceIdentity.get().getPublic().getEncoded())));
        UserDataVariableResolver.stub("AGENT_JNLP_HOST", "Jenkins agent jnlp host", r -> r.host);
        UserDataVariableResolver.stub("AGENT_JNLP_PORT", "Jenkins agent jnlp port", r -> Util.fixNull((String)Integer.toString(Jenkins.get().getSlaveAgentPort())));
    }

    public static final class Entry {
        @Nonnull
        private final String name;
        @Nonnull
        private final String description;
        @Nonnull
        private final ValueCalculator vc;

        private Entry(@Nonnull String name, @Nonnull String docs, @Nonnull ValueCalculator vc) {
            this.name = name;
            this.description = docs;
            this.vc = vc;
        }

        @Nonnull
        public String getDescription() {
            return this.description;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }
    }

    @FunctionalInterface
    private static interface ValueCalculator {
        @Nonnull
        public String get(@Nonnull UserDataVariableResolver var1);
    }
}

