/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import hudson.Extension;
import hudson.model.ItemGroup;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.openstack.compute.JCloudsCloud;
import jenkins.plugins.openstack.compute.JCloudsSlaveTemplate;
import jenkins.plugins.openstack.compute.UserDataVariableResolver;
import org.jenkinsci.Symbol;
import org.jenkinsci.lib.configprovider.AbstractConfigProviderImpl;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class UserDataConfig
extends Config {
    private static final long serialVersionUID = -1136594228956429772L;

    @DataBoundConstructor
    public UserDataConfig(String id, String name, String comment, String content) {
        super(id, name, comment, content);
    }

    public ConfigProvider getDescriptor() {
        return (ConfigProvider)Jenkins.get().getDescriptorByType(UserDataConfigProvider.class);
    }

    @CheckForNull
    public static String resolve(@CheckForNull String userDataId) {
        if (userDataId == null) {
            return null;
        }
        Config userData = ConfigFiles.getByIdOrNull((ItemGroup)Jenkins.get(), (String)userDataId);
        if (userData == null) {
            throw new IllegalArgumentException("Unable to locate OpenStack user-data named '" + userDataId + "'");
        }
        if (!(userData instanceof UserDataConfig)) {
            throw new IllegalArgumentException("The config file used for user-data is not of the correct type: " + String.valueOf(userData.getClass()));
        }
        return userData.content.isEmpty() ? null : userData.content;
    }

    @Extension(ordinal=70.0)
    @Symbol(value={"openstackUserData"})
    public static class UserDataConfigProvider
    extends AbstractConfigProviderImpl {
        public UserDataConfigProvider() {
            this.load();
        }

        public ContentType getContentType() {
            return ContentType.DefinedType.HTML;
        }

        public String getDisplayName() {
            return "OpenStack User Data";
        }

        @Nonnull
        public Config newConfig(@Nonnull String id) {
            return new UserDataConfig(id, "UserData", "", "");
        }

        public Config convert(Config config) {
            return new UserDataConfig(config.id, config.name, config.comment, config.content);
        }

        @Restricted(value={DoNotUse.class})
        public Collection<UserDataVariableResolver.Entry> getVariables() {
            return UserDataVariableResolver.STUB.values();
        }

        @Restricted(value={DoNotUse.class})
        public Collection<String> usages(@Nonnull String id) {
            ArrayList<String> usages = new ArrayList<String>();
            for (JCloudsCloud cloud : JCloudsCloud.getClouds()) {
                for (JCloudsSlaveTemplate template : cloud.getTemplates()) {
                    if (!id.equals(template.getEffectiveSlaveOptions().getUserDataId())) continue;
                    usages.add(cloud.name + " / " + template.getName());
                }
            }
            return usages;
        }
    }
}

