/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.model.Describable;
import hudson.slaves.NodeProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.openstack.compute.SlaveOptionsDescriptor;
import jenkins.plugins.openstack.compute.slaveopts.BootSource;
import jenkins.plugins.openstack.compute.slaveopts.LauncherFactory;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class SlaveOptions
implements Describable<SlaveOptions>,
Serializable {
    private static final long serialVersionUID = -1L;
    private static final SlaveOptions EMPTY = new SlaveOptions(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    @CheckForNull
    private BootSource bootSource;
    @CheckForNull
    private final String hardwareId;
    @CheckForNull
    private final String networkId;
    @CheckForNull
    private final String userDataId;
    private final Integer instanceCap;
    private final Integer instancesMin;
    @CheckForNull
    private final String floatingIpPool;
    private final String securityGroups;
    @CheckForNull
    private final String availabilityZone;
    private final Integer startTimeout;
    @CheckForNull
    private final String keyPairName;
    private final Integer numExecutors;
    @CheckForNull
    private final String jvmOptions;
    private final String fsRoot;
    private final LauncherFactory launcherFactory;
    @CheckForNull
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final ArrayList<NodeProperty<?>> nodeProperties;
    @Deprecated
    transient String slaveType;
    @Deprecated
    transient String credentialsId;
    private final Integer retentionTime;
    @CheckForNull
    private final Boolean configDrive;
    @Deprecated
    @CheckForNull
    private transient String imageId;

    @CheckForNull
    public String getFsRoot() {
        return this.fsRoot;
    }

    @CheckForNull
    public BootSource getBootSource() {
        return this.bootSource;
    }

    @CheckForNull
    public String getHardwareId() {
        return this.hardwareId;
    }

    @CheckForNull
    public String getNetworkId() {
        return this.networkId;
    }

    @CheckForNull
    public String getUserDataId() {
        return this.userDataId;
    }

    public Integer getInstanceCap() {
        return this.instanceCap;
    }

    public Integer getInstancesMin() {
        return this.instancesMin;
    }

    @CheckForNull
    public String getFloatingIpPool() {
        return this.floatingIpPool;
    }

    public String getSecurityGroups() {
        return this.securityGroups;
    }

    @CheckForNull
    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Integer getStartTimeout() {
        return this.startTimeout;
    }

    @CheckForNull
    public String getKeyPairName() {
        return this.keyPairName;
    }

    public Integer getNumExecutors() {
        return this.numExecutors;
    }

    @CheckForNull
    public String getJvmOptions() {
        return this.jvmOptions;
    }

    public LauncherFactory getLauncherFactory() {
        return this.launcherFactory;
    }

    @CheckForNull
    public List<NodeProperty<?>> getNodeProperties() {
        return this.nodeProperties;
    }

    public Integer getRetentionTime() {
        return this.retentionTime;
    }

    @CheckForNull
    public Boolean getConfigDrive() {
        return this.configDrive;
    }

    public SlaveOptions(Builder b) {
        this(b.bootSource, b.hardwareId, b.networkId, b.userDataId, b.instanceCap, b.instancesMin, b.floatingIpPool, b.securityGroups, b.availabilityZone, b.startTimeout, b.keyPairName, b.numExecutors, b.jvmOptions, b.fsRoot, b.launcherFactory, b.nodeProperties, b.retentionTime, b.configDrive);
    }

    @DataBoundConstructor
    @Restricted(value={NoExternalUse.class})
    public SlaveOptions(@CheckForNull BootSource bootSource, String hardwareId, String networkId, String userDataId, Integer instanceCap, Integer instancesMin, String floatingIpPool, String securityGroups, String availabilityZone, Integer startTimeout, String keyPairName, Integer numExecutors, String jvmOptions, String fsRoot, LauncherFactory launcherFactory, @CheckForNull List<? extends NodeProperty<?>> nodeProperties, Integer retentionTime, @CheckForNull Boolean configDrive) {
        this.bootSource = bootSource;
        this.hardwareId = Util.fixEmpty((String)hardwareId);
        this.networkId = Util.fixEmpty((String)networkId);
        this.userDataId = Util.fixEmpty((String)userDataId);
        this.instanceCap = instanceCap;
        this.instancesMin = instancesMin;
        this.floatingIpPool = Util.fixEmpty((String)floatingIpPool);
        this.securityGroups = Util.fixEmpty((String)securityGroups);
        this.availabilityZone = Util.fixEmpty((String)availabilityZone);
        this.startTimeout = startTimeout;
        this.keyPairName = Util.fixEmpty((String)keyPairName);
        this.numExecutors = numExecutors;
        this.jvmOptions = Util.fixEmpty((String)jvmOptions);
        this.fsRoot = Util.fixEmpty((String)fsRoot);
        this.launcherFactory = launcherFactory;
        this.nodeProperties = nodeProperties != null ? Lists.newArrayList(nodeProperties) : null;
        this.retentionTime = retentionTime;
        this.configDrive = configDrive;
    }

    private Object readResolve() {
        if (this.bootSource == null && this.imageId != null) {
            this.bootSource = new BootSource.Image(this.imageId);
        }
        this.imageId = null;
        return this;
    }

    @Nonnull
    public SlaveOptions override(@Nonnull SlaveOptions o) {
        return new Builder().bootSource(this._override(this.bootSource, o.bootSource)).hardwareId(this._override(this.hardwareId, o.hardwareId)).networkId(this._override(this.networkId, o.networkId)).userDataId(this._override(this.userDataId, o.userDataId)).instanceCap(this._override(this.instanceCap, o.instanceCap)).instancesMin(this._override(this.instancesMin, o.instancesMin)).floatingIpPool(this._override(this.floatingIpPool, o.floatingIpPool)).securityGroups(this._override(this.securityGroups, o.securityGroups)).availabilityZone(this._override(this.availabilityZone, o.availabilityZone)).startTimeout(this._override(this.startTimeout, o.startTimeout)).keyPairName(this._override(this.keyPairName, o.keyPairName)).numExecutors(this._override(this.numExecutors, o.numExecutors)).jvmOptions(this._override(this.jvmOptions, o.jvmOptions)).fsRoot(this._override(this.fsRoot, o.fsRoot)).launcherFactory(this._override(this.launcherFactory, o.launcherFactory)).nodeProperties((List)this._override(this.nodeProperties, o.nodeProperties)).retentionTime(this._override(this.retentionTime, o.retentionTime)).configDrive(this._override(this.configDrive, o.configDrive)).build();
    }

    @CheckForNull
    private <T> T _override(@CheckForNull T base, @CheckForNull T override) {
        return override == null ? base : override;
    }

    @Nonnull
    public SlaveOptions eraseDefaults(@Nonnull SlaveOptions defaults) {
        return new Builder().bootSource(this._erase(this.bootSource, defaults.bootSource)).hardwareId(this._erase(this.hardwareId, defaults.hardwareId)).networkId(this._erase(this.networkId, defaults.networkId)).userDataId(this._erase(this.userDataId, defaults.userDataId)).instanceCap(this._erase(this.instanceCap, defaults.instanceCap)).instancesMin(this._erase(this.instancesMin, defaults.instancesMin)).floatingIpPool(this._erase(this.floatingIpPool, defaults.floatingIpPool)).securityGroups(this._erase(this.securityGroups, defaults.securityGroups)).availabilityZone(this._erase(this.availabilityZone, defaults.availabilityZone)).startTimeout(this._erase(this.startTimeout, defaults.startTimeout)).keyPairName(this._erase(this.keyPairName, defaults.keyPairName)).numExecutors(this._erase(this.numExecutors, defaults.numExecutors)).jvmOptions(this._erase(this.jvmOptions, defaults.jvmOptions)).fsRoot(this._erase(this.fsRoot, defaults.fsRoot)).launcherFactory(this._erase(this.launcherFactory, defaults.launcherFactory)).nodeProperties((List)this._erase(this.nodeProperties, defaults.nodeProperties)).retentionTime(this._erase(this.retentionTime, defaults.retentionTime)).configDrive(this._erase(this.configDrive, defaults.configDrive)).build();
    }

    @CheckForNull
    private <T> T _erase(@CheckForNull T base, @CheckForNull T def) {
        if (def == null) {
            return base;
        }
        if (def.equals(base)) {
            return null;
        }
        return base;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("bootSource", (Object)this.bootSource).append("hardwareId", (Object)this.hardwareId).append("networkId", (Object)this.networkId).append("userDataId", (Object)this.userDataId).append("instanceCap", (Object)this.instanceCap).append("instancesMin", (Object)this.instancesMin).append("floatingIpPool", (Object)this.floatingIpPool).append("securityGroups", (Object)this.securityGroups).append("availabilityZone", (Object)this.availabilityZone).append("startTimeout", (Object)this.startTimeout).append("keyPairName", (Object)this.keyPairName).append("numExecutors", (Object)this.numExecutors).append("jvmOptions", (Object)this.jvmOptions).append("fsRoot", (Object)this.fsRoot).append("launcherFactory", (Object)this.launcherFactory).append("nodeProperties", this.nodeProperties).append("retentionTime", (Object)this.retentionTime).append("configDrive", (Object)this.configDrive).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlaveOptions that = (SlaveOptions)o;
        if (!Objects.equals(this.bootSource, that.bootSource)) {
            return false;
        }
        if (!Objects.equals(this.hardwareId, that.hardwareId)) {
            return false;
        }
        if (!Objects.equals(this.networkId, that.networkId)) {
            return false;
        }
        if (!Objects.equals(this.userDataId, that.userDataId)) {
            return false;
        }
        if (!Objects.equals(this.instanceCap, that.instanceCap)) {
            return false;
        }
        if (!Objects.equals(this.instancesMin, that.instancesMin)) {
            return false;
        }
        if (!Objects.equals(this.floatingIpPool, that.floatingIpPool)) {
            return false;
        }
        if (!Objects.equals(this.securityGroups, that.securityGroups)) {
            return false;
        }
        if (!Objects.equals(this.availabilityZone, that.availabilityZone)) {
            return false;
        }
        if (!Objects.equals(this.startTimeout, that.startTimeout)) {
            return false;
        }
        if (!Objects.equals(this.keyPairName, that.keyPairName)) {
            return false;
        }
        if (!Objects.equals(this.numExecutors, that.numExecutors)) {
            return false;
        }
        if (!Objects.equals(this.jvmOptions, that.jvmOptions)) {
            return false;
        }
        if (!Objects.equals(this.fsRoot, that.fsRoot)) {
            return false;
        }
        if (!Objects.equals(this.launcherFactory, that.launcherFactory)) {
            return false;
        }
        if (!Objects.equals(this.nodeProperties, that.nodeProperties)) {
            return false;
        }
        if (!Objects.equals(this.retentionTime, that.retentionTime)) {
            return false;
        }
        return Objects.equals(this.configDrive, that.configDrive);
    }

    public int hashCode() {
        int result = this.bootSource != null ? this.bootSource.hashCode() : 0;
        result = 31 * result + (this.hardwareId != null ? this.hardwareId.hashCode() : 0);
        result = 31 * result + (this.networkId != null ? this.networkId.hashCode() : 0);
        result = 31 * result + (this.userDataId != null ? this.userDataId.hashCode() : 0);
        result = 31 * result + (this.instanceCap != null ? this.instanceCap.hashCode() : 0);
        result = 31 * result + (this.instancesMin != null ? this.instancesMin.hashCode() : 0);
        result = 31 * result + (this.floatingIpPool != null ? this.floatingIpPool.hashCode() : 0);
        result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
        result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
        result = 31 * result + (this.startTimeout != null ? this.startTimeout.hashCode() : 0);
        result = 31 * result + (this.keyPairName != null ? this.keyPairName.hashCode() : 0);
        result = 31 * result + (this.numExecutors != null ? this.numExecutors.hashCode() : 0);
        result = 31 * result + (this.jvmOptions != null ? this.jvmOptions.hashCode() : 0);
        result = 31 * result + (this.fsRoot != null ? this.fsRoot.hashCode() : 0);
        result = 31 * result + (this.launcherFactory != null ? this.launcherFactory.hashCode() : 0);
        result = 31 * result + (this.nodeProperties != null ? this.nodeProperties.hashCode() : 0);
        result = 31 * result + (this.retentionTime != null ? this.retentionTime.hashCode() : 0);
        result = 31 * result + (this.configDrive != null ? this.configDrive.hashCode() : 0);
        return result;
    }

    public Builder getBuilder() {
        return new Builder().bootSource(this.bootSource).hardwareId(this.hardwareId).networkId(this.networkId).userDataId(this.userDataId).instanceCap(this.instanceCap).instancesMin(this.instancesMin).floatingIpPool(this.floatingIpPool).securityGroups(this.securityGroups).availabilityZone(this.availabilityZone).startTimeout(this.startTimeout).keyPairName(this.keyPairName).numExecutors(this.numExecutors).jvmOptions(this.jvmOptions).fsRoot(this.fsRoot).launcherFactory(this.launcherFactory).nodeProperties(this.nodeProperties).retentionTime(this.retentionTime).configDrive(this.configDrive);
    }

    @Nonnull
    public static SlaveOptions empty() {
        return EMPTY;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public SlaveOptionsDescriptor getDescriptor() {
        return (SlaveOptionsDescriptor)Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    public static final class Builder {
        @CheckForNull
        private BootSource bootSource;
        @CheckForNull
        private String hardwareId;
        @CheckForNull
        private String networkId;
        @CheckForNull
        private String userDataId;
        @CheckForNull
        private Integer instanceCap;
        @CheckForNull
        private Integer instancesMin;
        @CheckForNull
        private String floatingIpPool;
        @CheckForNull
        private String securityGroups;
        @CheckForNull
        private String availabilityZone;
        @CheckForNull
        private Integer startTimeout;
        @CheckForNull
        private String keyPairName;
        @CheckForNull
        private Integer numExecutors;
        @CheckForNull
        private String jvmOptions;
        @CheckForNull
        private String fsRoot;
        @CheckForNull
        private LauncherFactory launcherFactory;
        @CheckForNull
        private List<? extends NodeProperty<?>> nodeProperties;
        @CheckForNull
        private Integer retentionTime;
        @CheckForNull
        private Boolean configDrive;

        @Nonnull
        public SlaveOptions build() {
            return new SlaveOptions(this);
        }

        @Nonnull
        public Builder bootSource(BootSource bootSource) {
            this.bootSource = bootSource;
            return this;
        }

        @Nonnull
        public Builder hardwareId(String hardwareId) {
            this.hardwareId = hardwareId;
            return this;
        }

        @Nonnull
        public Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        @Nonnull
        public Builder userDataId(String userDataId) {
            this.userDataId = userDataId;
            return this;
        }

        @Nonnull
        public Builder instanceCap(Integer instanceCap) {
            this.instanceCap = instanceCap;
            return this;
        }

        @Nonnull
        public Builder instancesMin(Integer instancesMin) {
            this.instancesMin = instancesMin;
            return this;
        }

        @Nonnull
        public Builder floatingIpPool(String floatingIpPool) {
            this.floatingIpPool = floatingIpPool;
            return this;
        }

        @Nonnull
        public Builder securityGroups(String securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        @Nonnull
        public Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        @Nonnull
        public Builder startTimeout(Integer startTimeout) {
            this.startTimeout = startTimeout;
            return this;
        }

        @Nonnull
        public Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        @Nonnull
        public Builder numExecutors(Integer numExecutors) {
            this.numExecutors = numExecutors;
            return this;
        }

        @Nonnull
        public Builder jvmOptions(String jvmOptions) {
            this.jvmOptions = jvmOptions;
            return this;
        }

        @Nonnull
        public Builder fsRoot(String fsRoot) {
            this.fsRoot = fsRoot;
            return this;
        }

        @Nonnull
        public Builder launcherFactory(LauncherFactory launcherFactory) {
            this.launcherFactory = launcherFactory;
            return this;
        }

        @Nonnull
        public Builder nodeProperties(List<? extends NodeProperty<?>> nodeProperties) {
            this.nodeProperties = nodeProperties;
            return this;
        }

        @Nonnull
        public Builder retentionTime(Integer retentionTime) {
            this.retentionTime = retentionTime;
            return this;
        }

        @Nonnull
        public Builder configDrive(Boolean configDrive) {
            this.configDrive = configDrive;
            return this;
        }
    }

    public static interface Holder {
        @Nonnull
        public SlaveOptions getEffectiveSlaveOptions();

        @Nonnull
        public SlaveOptions getRawSlaveOptions();
    }
}

