/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import hudson.model.Job;
import hudson.model.Run;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.openstack.compute.JCloudsSlave;
import org.jenkinsci.plugins.cloudstats.CloudStatistics;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.openstack4j.model.compute.Server;

@Restricted(value={NoExternalUse.class})
public abstract class ServerScope {
    private static final Logger LOGGER = Logger.getLogger(ServerScope.class.getName());
    public static final String METADATA_KEY = "jenkins-scope";
    @Nonnull
    protected final String name;
    @Nonnull
    protected final String specifier;

    public static ServerScope parse(String scope) throws IllegalArgumentException {
        if (scope.startsWith("unlimited")) {
            return Unlimited.getInstance();
        }
        String[] chunks = scope.trim().split(":", 2);
        if (chunks.length != 2) {
            throw new IllegalArgumentException("Invalid scope: " + scope);
        }
        if ("node".equals(chunks[0])) {
            return new Node(chunks[1]);
        }
        if ("run".equals(chunks[0])) {
            return new Build(chunks[1]);
        }
        if ("time".equals(chunks[0])) {
            return new Time(chunks[1]);
        }
        throw new IllegalArgumentException("Invalid scope kind: " + chunks[0]);
    }

    private ServerScope(@Nonnull String scopeName, @Nonnull String specifier) {
        this.name = scopeName;
        this.specifier = specifier;
    }

    @Nonnull
    public static ServerScope extract(Server server) throws IllegalStateException {
        String scope = (String)server.getMetadata().get(METADATA_KEY);
        if (scope == null) {
            return Unlimited.getInstance();
        }
        try {
            return ServerScope.parse(scope);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException("Unable to parse scope '" + scope + "' of " + server.getName());
        }
    }

    public String toString() {
        return this.getValue();
    }

    public String getValue() {
        return this.name + ":" + this.specifier;
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.specifier.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerScope that = (ServerScope)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.specifier.equals(that.specifier)) {
            return false;
        }
        return this._equals(that);
    }

    protected boolean _equals(ServerScope o) {
        return true;
    }

    public abstract boolean isOutOfScope(@Nonnull Server var1);

    public static final class Unlimited
    extends ServerScope {
        private static Unlimited INSTANCE = new Unlimited();

        private Unlimited() {
            super("unlimited", "unlimited");
        }

        public static Unlimited getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean isOutOfScope(@Nonnull Server server) {
            return false;
        }
    }

    public static final class Node
    extends ServerScope {
        @Nonnull
        private final String name;
        @CheckForNull
        private final Integer cloudStatsFingerprint;

        public Node(@Nonnull String specifier) {
            super("node", specifier);
            String[] split = specifier.split(":");
            switch (split.length) {
                case 1: {
                    this.name = specifier;
                    this.cloudStatsFingerprint = null;
                    break;
                }
                case 2: {
                    this.name = split[0];
                    this.cloudStatsFingerprint = Integer.parseInt(split[1]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid node scope specifier " + specifier);
                }
            }
        }

        public Node(@Nonnull String serverName, @Nonnull ProvisioningActivity.Id id) {
            super("node", serverName + ":" + id.getFingerprint());
            this.name = serverName;
            this.cloudStatsFingerprint = id.getFingerprint();
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isOutOfScope(@Nonnull Server server) {
            long now;
            long ageHours;
            Date created;
            if (this.computerExists()) {
                return false;
            }
            if (this.cloudStatsFingerprint != null) {
                for (ProvisioningActivity pa : CloudStatistics.get().getActivities()) {
                    if (pa.getId().getFingerprint() != this.cloudStatsFingerprint.intValue()) continue;
                    switch (pa.getCurrentPhase()) {
                        case PROVISIONING: {
                            return false;
                        }
                        case LAUNCHING: 
                        case OPERATING: {
                            LOGGER.warning("Node does not exist for " + String.valueOf(pa.getCurrentPhase()) + " " + this.specifier);
                            return false;
                        }
                        case COMPLETED: {
                            return true;
                        }
                    }
                    assert (false) : "Unreachable";
                }
            }
            return (created = server.getCreated()) == null || (ageHours = ((now = System.currentTimeMillis()) - created.getTime()) / 3600000L) >= 1L;
        }

        private boolean computerExists() {
            hudson.model.Node node = Jenkins.get().getNode(this.getName());
            if (!(node instanceof JCloudsSlave)) {
                return false;
            }
            if (this.cloudStatsFingerprint == null) {
                return true;
            }
            JCloudsSlave slave = (JCloudsSlave)node;
            return this.cloudStatsFingerprint.intValue() == slave.getId().getFingerprint();
        }
    }

    public static final class Build
    extends ServerScope {
        @Nonnull
        private final String project;
        private final int run;

        public Build(Run run) {
            this(run.getParent().getFullName() + ":" + run.getNumber());
        }

        public Build(String specifier) {
            super("run", specifier);
            String[] chunks = this.specifier.split(":", 2);
            if (chunks.length != 2) {
                throw new IllegalArgumentException("Invalid run specifier: " + specifier);
            }
            this.project = chunks[0];
            this.run = Integer.parseInt(chunks[1]);
            if (this.project.isEmpty() || this.run < 0) {
                throw new IllegalArgumentException("Invalid run specifier: " + specifier);
            }
        }

        @Nonnull
        public String getProject() {
            return this.project;
        }

        public int getRunNumber() {
            return this.run;
        }

        @Override
        public boolean isOutOfScope(@Nonnull Server server) {
            Job job = (Job)Jenkins.get().getItemByFullName(this.project, Job.class);
            if (job == null) {
                return true;
            }
            Run run = job.getBuildByNumber(this.run);
            if (run == null) {
                return true;
            }
            return !run.isLogUpdated();
        }

        @Override
        protected boolean _equals(ServerScope o) {
            Build that = (Build)o;
            return this.run == that.run && this.project.equals(that.project);
        }
    }

    public static final class Time
    extends ServerScope {
        private final long aliveUntil;

        public Time(int duration, TimeUnit tu) {
            this(System.currentTimeMillis() + tu.toMillis(duration));
        }

        private Time(long millis) {
            super("time", Time.format().format(new Date(millis)));
            this.aliveUntil = millis;
        }

        private static SimpleDateFormat format() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }

        public Time(String specifier) {
            super("time", specifier);
            try {
                this.aliveUntil = Time.format().parse(specifier).getTime();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public boolean isOutOfScope(@Nonnull Server server) {
            return System.currentTimeMillis() > this.aliveUntil;
        }

        @Override
        public String getValue() {
            return this.name + ":" + Time.format().format(new Date(this.aliveUntil));
        }

        @Override
        protected boolean _equals(ServerScope o) {
            Time that = (Time)o;
            return this.aliveUntil == that.aliveUntil;
        }
    }
}

