/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import hudson.util.ReflectionUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jenkins.plugins.openstack.compute.auth.OpenstackCredential;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.util.StringUtils;

@Restricted(value={NoExternalUse.class})
public abstract class OsAuthDescriptor<DESCRIBABLE extends Describable<DESCRIBABLE>>
extends Descriptor<DESCRIBABLE> {
    public OsAuthDescriptor() {
    }

    public OsAuthDescriptor(Class<DESCRIBABLE> describableClass) {
        super(describableClass);
    }

    public abstract List<String> getAuthFieldsOffsets();

    protected static boolean hasValue(ListBoxModel m, String value) {
        for (ListBoxModel.Option o : m) {
            if (!Objects.equals(value, o.value)) continue;
            return true;
        }
        return false;
    }

    public final void calcFillSettings(String field, Map<String, Object> attributes) {
        super.calcFillSettings(field, attributes);
        ArrayList<Object> deps = new ArrayList<Object>();
        String fillDependsOn = (String)attributes.get("fillDependsOn");
        if (fillDependsOn != null) {
            deps.addAll(Arrays.asList(fillDependsOn.split(" ")));
        }
        String capitalizedFieldName = StringUtils.capitalize((String)field);
        String methodName = "doFill" + capitalizedFieldName + "Items";
        Method method = ReflectionUtils.getPublicMethodNamed(((Object)((Object)this)).getClass(), (String)methodName);
        if (method.getAnnotation(InjectOsAuth.class) != null) {
            for (String attr : Arrays.asList("endPointUrl", "ignoreSsl", "credentialsId", "zone", "cleanfreq")) {
                deps.remove(attr);
                for (String offset : this.getAuthFieldsOffsets()) {
                    deps.add(offset + "/" + attr);
                }
            }
        }
        if (!deps.isEmpty()) {
            attributes.put("fillDependsOn", String.join((CharSequence)" ", deps));
        }
    }

    protected static boolean haveAuthDetails(String endPointUrl, OpenstackCredential openstackCredential, String zone) {
        return Util.fixEmpty((String)endPointUrl) != null && openstackCredential != null;
    }

    public static String getDefault(String d1, Object d2) {
        if ((d1 = Util.fixEmpty((String)d1)) != null) {
            return d1;
        }
        if (d2 != null) {
            return Util.fixEmpty((String)String.valueOf(d2));
        }
        return null;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface InjectOsAuth {
    }
}

