/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Label;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.util.FormValidation;
import hudson.util.VariableResolver;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.openstack.compute.JCloudsCloud;
import jenkins.plugins.openstack.compute.JCloudsComputer;
import jenkins.plugins.openstack.compute.JCloudsSlave;
import jenkins.plugins.openstack.compute.ServerScope;
import jenkins.plugins.openstack.compute.SlaveOptions;
import jenkins.plugins.openstack.compute.UserDataConfig;
import jenkins.plugins.openstack.compute.UserDataVariableResolver;
import jenkins.plugins.openstack.compute.internal.DestroyMachine;
import jenkins.plugins.openstack.compute.internal.Openstack;
import jenkins.plugins.openstack.compute.internal.TokenGroup;
import jenkins.plugins.openstack.compute.slaveopts.BootSource;
import jenkins.plugins.openstack.compute.slaveopts.LauncherFactory;
import org.jenkinsci.plugins.cloudstats.CloudStatistics;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.resourcedisposer.AsyncResourceDisposer;
import org.jenkinsci.plugins.resourcedisposer.Disposable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.openstack4j.api.Builders;
import org.openstack4j.model.common.BasicResource;
import org.openstack4j.model.common.IdEntity;
import org.openstack4j.model.compute.Server;
import org.openstack4j.model.compute.builder.ServerCreateBuilder;
import org.openstack4j.model.network.Network;

public class JCloudsSlaveTemplate
implements Describable<JCloudsSlaveTemplate>,
SlaveOptions.Holder {
    public static final String OPENSTACK_CLOUD_NAME_KEY = "jenkins-cloud-name";
    public static final String OPENSTACK_TEMPLATE_NAME_KEY = "jenkins-template-name";
    private static final Logger LOGGER = Logger.getLogger(JCloudsSlaveTemplate.class.getName());
    private static final AtomicInteger nodeCounter = new AtomicInteger();
    private static final int pollingPeriodWhileWaitingForProvisioning = 6000;
    @Nonnull
    private final String name;
    @Nonnull
    private final String labelString;
    @Nonnull
    private SlaveOptions slaveOptions;
    private transient Set<LabelAtom> labelSet;
    private transient JCloudsCloud cloud;
    @Deprecated
    private transient String imageId;
    @Deprecated
    private transient String hardwareId;
    @Deprecated
    private transient String userDataId;
    @Deprecated
    private transient String numExecutors;
    @Deprecated
    private transient String jvmOptions;
    @Deprecated
    private transient String fsRoot;
    @Deprecated
    private transient Integer overrideRetentionTime;
    @Deprecated
    private transient String keyPairName;
    @Deprecated
    private transient String networkId;
    @Deprecated
    private transient String securityGroups;
    @Deprecated
    private transient String credentialsId;
    @Deprecated
    private transient String slaveType;
    @Deprecated
    private transient String availabilityZone;

    @DataBoundConstructor
    public JCloudsSlaveTemplate(@Nonnull String name, @Nonnull String labels, @CheckForNull SlaveOptions slaveOptions) {
        this.name = Util.fixNull((String)name).trim();
        this.labelString = Util.fixNull((String)labels).trim();
        this.slaveOptions = slaveOptions == null ? SlaveOptions.empty() : slaveOptions;
        this.readResolve();
    }

    @SuppressFBWarnings(value={"deprecation", "UnusedReturnValue", "RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private Object readResolve() {
        LauncherFactory lf;
        int i;
        this.labelSet = Label.parse((String)this.labelString);
        if (this.hardwareId != null && (i = this.hardwareId.indexOf(47)) != -1) {
            this.hardwareId = this.hardwareId.substring(i + 1);
        }
        if (this.networkId != null && (i = this.networkId.indexOf(47)) != -1) {
            this.networkId = this.networkId.substring(i + 1);
        }
        if (this.imageId != null && (i = this.imageId.indexOf(47)) != -1) {
            this.imageId = this.imageId.substring(i + 1);
        }
        if (this.slaveOptions == null) {
            lf = null;
            if ("SSH".equals(this.slaveType) || this.credentialsId != null) {
                lf = new LauncherFactory.SSH(this.credentialsId);
            } else if ("JNLP".equals(this.slaveType)) {
                lf = LauncherFactory.JNLP.JNLP;
            }
            BootSource.Image bs = this.imageId == null ? null : new BootSource.Image(this.imageId);
            this.slaveOptions = SlaveOptions.builder().bootSource(bs).hardwareId(this.hardwareId).numExecutors(Integer.getInteger(this.numExecutors)).jvmOptions(this.jvmOptions).userDataId(this.userDataId).fsRoot(this.fsRoot).retentionTime(this.overrideRetentionTime).keyPairName(this.keyPairName).networkId(this.networkId).securityGroups(this.securityGroups).launcherFactory(lf).availabilityZone(this.availabilityZone).build();
            this.hardwareId = null;
            this.numExecutors = null;
            this.jvmOptions = null;
            this.userDataId = null;
            this.fsRoot = null;
            this.overrideRetentionTime = null;
            this.keyPairName = null;
            this.networkId = null;
            this.securityGroups = null;
            this.credentialsId = null;
            this.slaveType = null;
            this.availabilityZone = null;
        }
        if (this.slaveOptions.slaveType != null) {
            lf = null;
            if ("JNLP".equals(this.slaveOptions.slaveType)) {
                lf = LauncherFactory.JNLP.JNLP;
                this.slaveOptions.slaveType = null;
            } else if ("SSH".equals(this.slaveOptions.slaveType)) {
                lf = new LauncherFactory.SSH(this.slaveOptions.credentialsId);
                this.slaveOptions.credentialsId = null;
                this.slaveOptions.slaveType = null;
            }
            if (lf != null) {
                this.slaveOptions = this.slaveOptions.getBuilder().launcherFactory(lf).build();
            }
        }
        return this;
    }

    @Restricted(value={NoExternalUse.class})
    void setOwner(JCloudsCloud cloud) {
        this.cloud = cloud;
        this.slaveOptions = this.slaveOptions.eraseDefaults(cloud.getEffectiveSlaveOptions());
    }

    @Override
    @Nonnull
    public SlaveOptions getEffectiveSlaveOptions() {
        return this.cloud.getEffectiveSlaveOptions().override(this.slaveOptions);
    }

    @Override
    @Nonnull
    public SlaveOptions getRawSlaveOptions() {
        if (this.cloud == null) {
            throw new IllegalStateException("Owner not set properly");
        }
        return this.slaveOptions;
    }

    public Set<LabelAtom> getLabelSet() {
        return this.labelSet;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Restricted(value={NoExternalUse.class})
    @Nonnull
    public String getLabels() {
        return this.labelString;
    }

    public boolean canProvision(Label label) {
        return label == null || label.matches(this.labelSet);
    }

    boolean hasProvisioned(@Nonnull Server server) {
        return this.getName().equals(server.getMetadata().get(OPENSTACK_TEMPLATE_NAME_KEY));
    }

    @Nonnull
    public JCloudsSlave provisionSlave(@Nonnull JCloudsCloud cloud, @Nonnull ProvisioningActivity.Id id) throws JCloudsCloud.ProvisioningFailedException {
        SlaveOptions opts = this.getEffectiveSlaveOptions();
        int timeout = opts.getStartTimeout();
        Server server = this.provisionServer(null, id);
        JCloudsSlave node = null;
        try {
            String cause;
            node = new JCloudsSlave(id, server, this.labelString, opts);
            while ((cause = cloud.slaveIsWaitingFor(node)) != null) {
                if (node.isLaunchTimedOut()) {
                    Object timeoutMessage = String.format("Failed to connect agent %s within timeout (%d ms): %s", node.getNodeName(), timeout, cause);
                    Error errorQuerying = null;
                    try {
                        Server freshServer = cloud.getOpenstack().getServerById(server.getId());
                        timeoutMessage = (String)timeoutMessage + System.lineSeparator() + "Server state: " + String.valueOf(freshServer);
                    }
                    catch (NoSuchElementException ex) {
                        timeoutMessage = (String)timeoutMessage + System.lineSeparator() + "Server does no longer exist: " + server.getId();
                    }
                    catch (Error ex) {
                        errorQuerying = ex;
                    }
                    LOGGER.warning((String)timeoutMessage);
                    JCloudsCloud.ProvisioningFailedException ex = new JCloudsCloud.ProvisioningFailedException((String)timeoutMessage);
                    if (errorQuerying != null) {
                        ex.addSuppressed(errorQuerying);
                    }
                    throw ex;
                }
                Thread.sleep(6000L);
            }
            return node;
        }
        catch (Throwable ex) {
            JCloudsCloud.ProvisioningFailedException cause;
            JCloudsCloud.ProvisioningFailedException provisioningFailedException = cause = ex instanceof JCloudsCloud.ProvisioningFailedException ? (JCloudsCloud.ProvisioningFailedException)ex : new JCloudsCloud.ProvisioningFailedException(ex.getMessage(), ex);
            if (node != null) {
                node._terminate(TaskListener.NULL);
            }
            throw cause;
        }
    }

    @Restricted(value={NoExternalUse.class})
    @Nonnull
    public Server provisionServer(@CheckForNull ServerScope scope, @CheckForNull ProvisioningActivity.Id id) throws Openstack.ActionFailed {
        Boolean configDrive;
        String userDataText;
        String az;
        String kpn;
        String securityGroups;
        String nid;
        String serverName = this.getServerName();
        SlaveOptions opts = this.getEffectiveSlaveOptions();
        ServerCreateBuilder builder = Builders.server();
        builder.addMetadataItem(OPENSTACK_TEMPLATE_NAME_KEY, this.getName());
        builder.addMetadataItem(OPENSTACK_CLOUD_NAME_KEY, this.cloud.name);
        if (scope == null) {
            scope = id == null ? new ServerScope.Node(serverName) : new ServerScope.Node(serverName, id);
        }
        builder.addMetadataItem("jenkins-scope", scope.getValue());
        LOGGER.info("Provisioning new openstack server " + serverName + " with options " + String.valueOf(opts));
        builder.name(serverName);
        Openstack openstack = this.cloud.getOpenstack();
        BootSource bootSource = opts.getBootSource();
        if (bootSource == null) {
            LOGGER.warning("No " + BootSource.class.getSimpleName() + " set for " + this.getClass().getSimpleName() + " with name='" + this.getName() + "'.");
        } else {
            LOGGER.fine("Setting boot options to " + String.valueOf(bootSource));
            bootSource.setServerBootSource(builder, openstack);
        }
        String hwid = opts.getHardwareId();
        if (Util.fixEmpty((String)hwid) != null) {
            LOGGER.fine("Setting hardware Id to " + hwid);
            builder.flavor(hwid);
        }
        if (Util.fixEmpty((String)(nid = opts.getNetworkId())) != null) {
            List<String> networks = JCloudsSlaveTemplate.selectNetworkIds(openstack, nid);
            LOGGER.fine("Setting networks to " + String.valueOf(networks));
            builder.networks(networks);
        }
        if (Util.fixEmpty((String)(securityGroups = opts.getSecurityGroups())) != null) {
            LOGGER.fine("Setting security groups to " + securityGroups);
            for (String sg : JCloudsSlaveTemplate.parseSecurityGroups(securityGroups)) {
                builder.addSecurityGroup(sg);
            }
        }
        if (Util.fixEmpty((String)(kpn = opts.getKeyPairName())) != null) {
            LOGGER.fine("Setting keyPairName to " + kpn);
            builder.keypairName(kpn);
        }
        if (Util.fixEmpty((String)(az = opts.getAvailabilityZone())) != null) {
            LOGGER.fine("Setting availabilityZone to " + az);
            builder.availabilityZone(az);
        }
        if ((userDataText = this.getUserData()) != null) {
            String rootUrl = Util.fixNull((String)Jenkins.get().getRootUrl());
            UserDataVariableResolver resolver = new UserDataVariableResolver(rootUrl, serverName, this.labelString, opts);
            String content = Util.replaceMacro((String)userDataText, (VariableResolver)resolver);
            assert (content != null);
            LOGGER.fine("Sending user-data:\n" + content);
            byte[] binaryData = content.getBytes(StandardCharsets.UTF_8);
            String result = Base64.getEncoder().encodeToString(binaryData);
            builder.userData(result);
        }
        if ((configDrive = opts.getConfigDrive()) != null) {
            builder.configDrive(configDrive.booleanValue());
        }
        Server server = openstack.bootAndWaitActive(builder, opts.getStartTimeout());
        try {
            if (bootSource != null) {
                bootSource.afterProvisioning(server, openstack);
            }
            LOGGER.info("Provisioned: " + String.valueOf(server));
            String poolName = opts.getFloatingIpPool();
            if (poolName != null) {
                LOGGER.fine("Assigning floating IP from " + poolName + " to " + serverName);
                server = openstack.assignFloatingIp(server, poolName);
                LOGGER.info("Amended server: " + String.valueOf(server));
            }
            return server;
        }
        catch (Throwable ex) {
            AsyncResourceDisposer.get().dispose(new Disposable[]{new DestroyMachine(this.cloud.name, server.getId())});
            throw ex;
        }
    }

    private String getServerName() {
        String nameCandidate;
        CloudStatistics cs = CloudStatistics.get();
        block0: while (true) {
            nameCandidate = this.getName() + "-" + nodeCounter.getAndIncrement();
            if (Jenkins.get().getNode(nameCandidate) != null) continue;
            for (ProvisioningActivity provisioningActivity : cs.getActivities()) {
                if (!nameCandidate.equals(provisioningActivity.getId().getNodeName())) continue;
                continue block0;
            }
            break;
        }
        return nameCandidate;
    }

    @Nonnull
    @VisibleForTesting
    static List<String> parseSecurityGroups(@Nonnull String securityGroups) {
        if (securityGroups == null || securityGroups.isEmpty()) {
            throw new IllegalArgumentException();
        }
        List<String> from = TokenGroup.from(securityGroups, ',');
        if (from.isEmpty() || from.contains("")) {
            throw new IllegalArgumentException("Security group declaration contains blank '" + securityGroups + "'");
        }
        return from;
    }

    @Nonnull
    @VisibleForTesting
    static List<String> selectNetworkIds(@Nonnull Openstack openstack, @Nonnull String spec) {
        if (spec == null || spec.isEmpty()) {
            throw new IllegalArgumentException();
        }
        List<List<String>> declared = TokenGroup.from(spec, ',', '|');
        List<String> allDeclaredNetworks = declared.stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (declared.isEmpty() || declared.contains(Collections.emptyList()) || allDeclaredNetworks.contains("")) {
            throw new IllegalArgumentException("Networks declaration contains blank '" + String.valueOf(declared) + "'");
        }
        Map<String, Network> osNetworksById = openstack.getNetworks(allDeclaredNetworks);
        Map<String, Network> osNetworksByName = osNetworksById.values().stream().collect(Collectors.toMap(BasicResource::getName, n -> n));
        Function<String, String> RESOLVE_NAMES_TO_IDS = n -> {
            if (osNetworksById.containsKey(n)) {
                return n;
            }
            Network network = osNetworksByName.getOrDefault(n, null);
            if (network != null) {
                return network.getId();
            }
            throw new IllegalArgumentException("No network '" + n + "' found for " + spec);
        };
        if (!spec.contains("|")) {
            return allDeclaredNetworks.stream().map(RESOLVE_NAMES_TO_IDS).collect(Collectors.toList());
        }
        Map<Network, Integer> capacities = openstack.getNetworksCapacity(osNetworksById);
        if (capacities.isEmpty()) {
            LOGGER.warning("OpenStack network-ip-availability endpoint is inaccessible, unable to balance the load for " + spec);
            return declared.stream().map(l -> (String)l.get(0)).map(RESOLVE_NAMES_TO_IDS).collect(Collectors.toList());
        }
        ArrayList<Network> ret = new ArrayList<Network>(declared.size());
        for (List<String> alternativeList : declared) {
            Optional<Network> emptiest = alternativeList.stream().map(RESOLVE_NAMES_TO_IDS).map(osNetworksById::get).min((l, r) -> {
                Integer lCap = (Integer)capacities.get(l);
                Integer rCap = (Integer)capacities.get(r);
                return rCap.compareTo(lCap);
            });
            assert (emptiest.isPresent()) : "Alternative set empty";
            Network network = emptiest.get();
            ret.add(network);
        }
        Function<Network, String> DESCRIBE_NETWORK = n -> n.getName() + "/" + n.getId();
        Map<String, Integer> userTokenBasedCapacities = capacities.keySet().stream().collect(Collectors.toMap(DESCRIBE_NETWORK, capacities::get));
        List networks = ret.stream().map(DESCRIBE_NETWORK).collect(Collectors.toList());
        LOGGER.fine("Resolving network spec '" + spec + "' to '" + String.valueOf(networks) + " given free capacity " + String.valueOf(userTokenBasedCapacities));
        Map<String, Long> exhaustedPools = ret.stream().collect(Collectors.groupingBy(n -> n, Collectors.counting())).entrySet().stream().filter(nle -> (long)((Integer)capacities.get(nle.getKey())).intValue() < (Long)nle.getValue()).collect(Collectors.toMap(nle -> ((Network)nle.getKey()).getName() + "/" + ((Network)nle.getKey()).getId(), Map.Entry::getValue));
        if (!exhaustedPools.isEmpty()) {
            LOGGER.warning("Not enough fixed IPs for " + spec + " with capacity " + String.valueOf(exhaustedPools));
        }
        return ret.stream().map(IdEntity::getId).collect(Collectors.toList());
    }

    @CheckForNull
    String getUserData() {
        return UserDataConfig.resolve(this.getEffectiveSlaveOptions().getUserDataId());
    }

    List<? extends Server> getRunningNodes() {
        ArrayList<Server> tmplt = new ArrayList<Server>();
        for (Server server : this.cloud.getOpenstack().getRunningNodes()) {
            if (!this.hasProvisioned(server)) continue;
            tmplt.add(server);
        }
        return tmplt;
    }

    int getAvailableNodesTotal() {
        int totalServers = 0;
        for (JCloudsComputer computer : JCloudsComputer.getAll()) {
            ProvisioningActivity.Id cid = computer.getId();
            if (!this.name.equals(cid.getTemplateName()) || !this.cloud.name.equals(cid.getCloudName()) || !computer.isIdle() || computer.isPendingDelete() || computer.isUserOffline()) continue;
            ++totalServers;
        }
        return totalServers;
    }

    public Descriptor<JCloudsSlaveTemplate> getDescriptor() {
        return Jenkins.get().getDescriptor(this.getClass());
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<JCloudsSlaveTemplate> {
        @Nonnull
        public String getDisplayName() {
            return this.clazz.getSimpleName();
        }

        @Restricted(value={DoNotUse.class})
        @RequirePOST
        public FormValidation doCheckName(@QueryParameter String value) {
            try {
                Jenkins.checkGoodName((String)value);
                return FormValidation.ok();
            }
            catch (Failure ex) {
                return FormValidation.error((String)ex.getMessage());
            }
        }
    }
}

