/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.node_monitors.DiskSpaceMonitorDescriptor;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.openstack.compute.JCloudsCloud;
import jenkins.plugins.openstack.compute.JCloudsComputer;
import jenkins.plugins.openstack.compute.JCloudsLauncher;
import jenkins.plugins.openstack.compute.JCloudsRetentionStrategy;
import jenkins.plugins.openstack.compute.SlaveOptions;
import jenkins.plugins.openstack.compute.internal.DestroyMachine;
import jenkins.plugins.openstack.compute.internal.Openstack;
import jenkins.plugins.openstack.compute.slaveopts.LauncherFactory;
import org.jenkinsci.plugins.cloudstats.CloudStatistics;
import org.jenkinsci.plugins.cloudstats.PhaseExecutionAttachment;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedItem;
import org.jenkinsci.plugins.resourcedisposer.AsyncResourceDisposer;
import org.jenkinsci.plugins.resourcedisposer.Disposable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.openstack4j.model.compute.Address;
import org.openstack4j.model.compute.Addresses;
import org.openstack4j.model.compute.Flavor;
import org.openstack4j.model.compute.Server;

public class JCloudsSlave
extends AbstractCloudSlave
implements TrackedItem {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(JCloudsSlave.class.getName());
    private static final List<String> HIDDEN_METADATA_VALUES = Arrays.asList("jenkins-identity", "jenkins-instance", "jenkins-cloud-name", "jenkins-template-name", "jenkins-scope");
    @Nonnull
    private final String cloudName;
    @Nonnull
    private SlaveOptions options;
    @Nonnull
    private final ProvisioningActivity.Id provisioningId;
    @Nonnull
    private transient Cache<String, Map<String, String>> cache;
    @Nonnull
    private String nodeId;
    private final long created = System.currentTimeMillis();
    @Deprecated
    private transient int overrideRetentionTime;
    @Deprecated
    private transient String jvmOptions;
    @Deprecated
    private transient String credentialsId;
    @Deprecated
    private transient String slaveType;
    @Deprecated
    private transient Server metadata;

    public JCloudsSlave(@Nonnull ProvisioningActivity.Id id, @Nonnull Server metadata, @Nonnull String labelString, @Nonnull SlaveOptions slaveOptions) throws IOException, Descriptor.FormException {
        super(Objects.requireNonNull(metadata.getName()), slaveOptions.getFsRoot(), null);
        this.cloudName = id.getCloudName();
        this.provisioningId = id;
        this.options = slaveOptions;
        this.nodeId = metadata.getId();
        this.cache = JCloudsSlave.makeCache();
        this.setNumExecutors(slaveOptions.getNumExecutors());
        this.setMode(Node.Mode.NORMAL);
        this.setLabelString(labelString);
        this.setRetentionStrategy(new JCloudsRetentionStrategy());
        this.setNodeProperties(JCloudsSlave.mkNodeProperties(Openstack.getAccessIpAddress(metadata), slaveOptions.getNodeProperties()));
        this.setLauncher((ComputerLauncher)new JCloudsLauncher(this.getLauncherFactory().createLauncher(this)));
    }

    @Nonnull
    private static List<NodeProperty<? extends Node>> mkNodeProperties(@CheckForNull String vmIpAddressOrNull, @CheckForNull List<? extends NodeProperty<?>> templateNPsOrNull) {
        String vmIpAddressOrEmpty = Util.fixNull((String)vmIpAddressOrNull);
        EnvironmentVariablesNodeProperty.Entry ipAddressEnvVar = new EnvironmentVariablesNodeProperty.Entry("OPENSTACK_PUBLIC_IP", vmIpAddressOrEmpty);
        List templateNPsOrEmpty = Util.fixNull(templateNPsOrNull);
        List<NodeProperty<? extends Node>> result = JCloudsSlave.mergeNodeProperties(templateNPsOrEmpty, ipAddressEnvVar);
        return result;
    }

    @Nonnull
    private static List<NodeProperty<? extends Node>> mergeNodeProperties(@Nonnull List<? extends NodeProperty<?>> templateNPs, EnvironmentVariablesNodeProperty.Entry ... extraEnvVarEntries) {
        EnvironmentVariablesNodeProperty envVarsNP = new EnvironmentVariablesNodeProperty(extraEnvVarEntries);
        ImmutableList.Builder b = ImmutableList.builder();
        boolean envVarsAdded = false;
        for (NodeProperty<?> templateNP : templateNPs) {
            if (!envVarsAdded && templateNP instanceof EnvironmentVariablesNodeProperty) {
                EnvironmentVariablesNodeProperty templateEnvVarNP = (EnvironmentVariablesNodeProperty)templateNP;
                EnvVars templateEnvVars = templateEnvVarNP.getEnvVars();
                EnvVars extraEnvVars = envVarsNP.getEnvVars();
                extraEnvVars.putAll((Map)templateEnvVars);
                b.add((Object)envVarsNP);
                envVarsAdded = true;
                continue;
            }
            NodeProperty<?> copyOfTemplateNP = JCloudsSlave.makeCopy(templateNP);
            b.add(copyOfTemplateNP);
        }
        if (!envVarsAdded && extraEnvVarEntries.length != 0) {
            b.add((Object)envVarsNP);
        }
        ImmutableList nodePropertiesList = b.build();
        return nodePropertiesList;
    }

    private static <T> T makeCopy(T original) {
        String xml = Jenkins.XSTREAM.toXML(original);
        Object copy = Jenkins.XSTREAM.fromXML(xml);
        return (T)copy;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE", "The fields are non-null after readResolve"})
    protected Object readResolve() {
        super.readResolve();
        this.cache = JCloudsSlave.makeCache();
        if (this.options == null) {
            SlaveOptions.Builder builder = JCloudsCloud.DescriptorImpl.getDefaultOptions().getBuilder().jvmOptions(Util.fixEmpty((String)this.jvmOptions));
            LauncherFactory lf = "SSH".equals(this.slaveType) ? new LauncherFactory.SSH(this.credentialsId) : LauncherFactory.JNLP.JNLP;
            builder.launcherFactory(lf);
            if (this.overrideRetentionTime > 0) {
                builder = builder.retentionTime(this.overrideRetentionTime);
            }
            this.options = builder.build();
            this.jvmOptions = null;
            this.credentialsId = null;
            this.slaveType = null;
        }
        if (!(this.metadata == null || this.nodeId != null && this.nodeId.equals(this.metadata.getId()))) {
            this.nodeId = this.metadata.getId();
            this.metadata = null;
        }
        this.nodeId = this.nodeId.replaceFirst(".*/", "");
        return this;
    }

    @Nonnull
    private static <K, V> Cache<K, V> makeCache() {
        return Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    }

    @Restricted(value={DoNotUse.class})
    @Nonnull
    public Map<String, String> getOpenstackSlaveData() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        SlaveOptions slaveOptions = this.getSlaveOptions();
        JCloudsSlave.putIfNotNullOrEmpty(result, "Network(s)", slaveOptions.getNetworkId());
        JCloudsSlave.putIfNotNullOrEmpty(result, "Floating Ip Pool", slaveOptions.getFloatingIpPool());
        JCloudsSlave.putIfNotNullOrEmpty(result, "Security Groups", slaveOptions.getSecurityGroups());
        JCloudsSlave.putIfNotNullOrEmpty(result, "Start Timeout (ms)", slaveOptions.getStartTimeout());
        LauncherFactory launcherFactory = slaveOptions.getLauncherFactory();
        JCloudsSlave.putIfNotNullOrEmpty(result, "Launcher Factory", launcherFactory == null ? null : launcherFactory.getClass().getSimpleName());
        JCloudsSlave.putIfNotNullOrEmpty(result, "JVM Options", slaveOptions.getJvmOptions());
        return result;
    }

    @Restricted(value={DoNotUse.class})
    @Nonnull
    public Map<String, String> getLiveOpenstackServerDetails() {
        return this.getCachableData("liveData", unused -> this.readLiveOpenstackServerDetails());
    }

    @Nonnull
    private Map<String, String> readLiveOpenstackServerDetails() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Server s = this.readOpenstackServer();
        if (s == null) {
            return result;
        }
        Addresses addresses = s.getAddresses();
        if (addresses != null) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry e : addresses.getAddresses().entrySet()) {
                String networkName = (String)e.getKey();
                for (Address address : (List)e.getValue()) {
                    if (sb.length() != 0) {
                        sb.append(", ");
                    }
                    sb.append(address.getAddr()).append(" (").append(address.getType()).append(" in ").append(networkName).append(")");
                }
            }
            JCloudsSlave.putIfNotNullOrEmpty(result, "Addresses", sb.toString());
        }
        JCloudsSlave.putIfNotNullOrEmpty(result, "Availability Zone", s.getAvailabilityZone());
        JCloudsSlave.putIfNotNullOrEmpty(result, "Config Drive", s.getConfigDrive());
        Flavor flavor = s.getFlavor();
        if (flavor != null) {
            JCloudsSlave.putIfNotNullOrEmpty(result, "Flavor", Openstack.getFlavorInfo(flavor));
        }
        JCloudsSlave.putIfNotNullOrEmpty(result, "Host", s.getHost());
        JCloudsSlave.putIfNotNullOrEmpty(result, "Instance Name", s.getInstanceName());
        JCloudsSlave.putIfNotNullOrEmpty(result, "Key Name", s.getKeyName());
        List volumes = s.getOsExtendedVolumesAttached();
        if (volumes != null && !volumes.isEmpty()) {
            JCloudsSlave.putIfNotNullOrEmpty(result, "osExtendedVolumesAttached", volumes);
        }
        JCloudsSlave.putIfNotNullOrEmpty(result, "Power State", s.getPowerState());
        JCloudsSlave.putIfNotNullOrEmpty(result, "Status", s.getStatus());
        JCloudsSlave.putIfNotNullOrEmpty(result, "Fault", s.getFault());
        JCloudsSlave.putIfNotNullOrEmpty(result, "Created", s.getCreated());
        JCloudsSlave.putIfNotNullOrEmpty(result, "Launched At", s.getLaunchedAt());
        JCloudsSlave.putIfNotNullOrEmpty(result, "Updated", s.getUpdated());
        JCloudsSlave.putIfNotNullOrEmpty(result, "Terminated At", s.getTerminatedAt());
        Map metaDataOrNull = s.getMetadata();
        if (metaDataOrNull != null) {
            for (Map.Entry e : metaDataOrNull.entrySet()) {
                String key = (String)e.getKey();
                if (HIDDEN_METADATA_VALUES.contains(key)) continue;
                JCloudsSlave.putIfNotNullOrEmpty(result, "metadata." + key, e.getValue());
            }
        }
        return result;
    }

    private Server readOpenstackServer() {
        try {
            return JCloudsSlave.getOpenstack(this.cloudName).getServerById(this.nodeId);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Unable to read details of server '" + this.nodeId + "' from cloud '" + this.cloudName + "'.", ex);
        }
        return null;
    }

    private static void putIfNotNullOrEmpty(@Nonnull Map<String, String> mapToBeAddedTo, @Nonnull String fieldName, @CheckForNull Object fieldValue) {
        String valueString;
        if (fieldValue != null && (valueString = Util.fixEmptyAndTrim((String)fieldValue.toString())) != null) {
            mapToBeAddedTo.put(fieldName, valueString);
        }
    }

    @Nonnull
    private Map<String, String> getCachableData(@Nonnull String key, @Nonnull Function<String, Map<String, String>> dataloader) {
        try {
            return Objects.requireNonNull((Map)this.cache.get((Object)key, dataloader));
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw e;
        }
    }

    @CheckForNull
    public String getPublicAddress() throws NoSuchElementException {
        return Openstack.getAccessIpAddress(JCloudsSlave.getOpenstack(this.cloudName).getServerById(this.nodeId));
    }

    @Nonnull
    public SlaveOptions getSlaveOptions() {
        this.options.getClass();
        return this.options;
    }

    @Nonnull
    public LauncherFactory getLauncherFactory() {
        LauncherFactory lf = this.options.getLauncherFactory();
        return lf == null ? LauncherFactory.JNLP.JNLP : lf;
    }

    public RetentionStrategy<JCloudsComputer> getRetentionStrategy() {
        return super.getRetentionStrategy();
    }

    @Restricted(value={NoExternalUse.class})
    @Nonnull
    public String getServerId() {
        return this.nodeId;
    }

    public AbstractCloudComputer<JCloudsSlave> createComputer() {
        LOGGER.info("Creating a new computer for " + this.getNodeName());
        return new JCloudsComputer(this);
    }

    @Nonnull
    public ProvisioningActivity.Id getId() {
        return this.provisioningId;
    }

    public long getCreatedTime() {
        return this.created;
    }

    public boolean isLaunchTimedOut() {
        JCloudsComputer computer = this.getComputer();
        if (computer != null && computer.isOnline()) {
            return false;
        }
        long existsFor = System.currentTimeMillis() - this.created;
        return existsFor > (long)this.getSlaveOptions().getStartTimeout().intValue();
    }

    public JCloudsComputer getComputer() {
        return (JCloudsComputer)super.getComputer();
    }

    protected void _terminate(TaskListener listener) {
        CloudStatistics cloudStatistics = CloudStatistics.get();
        ProvisioningActivity activity = cloudStatistics.getActivityFor((TrackedItem)this);
        if (activity != null) {
            activity.enterIfNotAlready(ProvisioningActivity.Phase.COMPLETED);
            OfflineCause offlineCause = this.getFatalOfflineCause();
            if (offlineCause != null) {
                PhaseExecutionAttachment attachment = new PhaseExecutionAttachment(ProvisioningActivity.Status.WARN, offlineCause.toString());
                cloudStatistics.attach(activity, ProvisioningActivity.Phase.COMPLETED, attachment);
            }
        }
        this.getLauncherFactory().onNodeTerminated();
        AsyncResourceDisposer.get().dispose(new Disposable[]{new RecordDisposal(new DestroyMachine(this.cloudName, this.nodeId), this.provisioningId)});
    }

    @CheckForNull
    OfflineCause getFatalOfflineCause() {
        OfflineCause oc;
        JCloudsComputer computer = this.getComputer();
        OfflineCause offlineCause = oc = computer != null ? computer.getOfflineCause() : this.getTemporaryOfflineCause();
        if (this.isLaunchTimedOut() && oc instanceof OfflineCause.LaunchFailed) {
            return oc;
        }
        return oc instanceof DiskSpaceMonitorDescriptor.DiskSpace || oc instanceof OfflineCause.ChannelTermination ? oc : null;
    }

    private static Openstack getOpenstack(String cloudName) {
        return JCloudsCloud.getByName(cloudName).getOpenstack();
    }

    private static final class RecordDisposal
    implements Disposable {
        private static final long serialVersionUID = -3623764445481732365L;
        @Nonnull
        private final Disposable inner;
        @Nonnull
        private final ProvisioningActivity.Id provisioningId;

        private RecordDisposal(@Nonnull Disposable inner, @Nonnull ProvisioningActivity.Id provisioningId) {
            this.inner = inner;
            this.provisioningId = provisioningId;
        }

        @Nonnull
        public Disposable.State dispose() throws Throwable {
            try {
                return this.inner.dispose();
            }
            catch (Throwable ex) {
                CloudStatistics statistics = CloudStatistics.get();
                ProvisioningActivity activity = statistics.getPotentiallyCompletedActivityFor(this.provisioningId);
                if (activity != null) {
                    PhaseExecutionAttachment.ExceptionAttachment attachment = new PhaseExecutionAttachment.ExceptionAttachment(ProvisioningActivity.Status.WARN, ex);
                    statistics.attach(activity, ProvisioningActivity.Phase.COMPLETED, (PhaseExecutionAttachment)attachment);
                }
                if (ex instanceof DestroyMachine.CloudGoneException) {
                    return Disposable.State.PURGED;
                }
                throw ex;
            }
        }

        @Nonnull
        public String getDisplayName() {
            return this.inner.getDisplayName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecordDisposal that = (RecordDisposal)o;
            if (!this.inner.equals(that.inner)) {
                return false;
            }
            return this.provisioningId.equals((Object)that.provisioningId);
        }

        public int hashCode() {
            return Objects.hash(this.inner.hashCode(), this.provisioningId.hashCode());
        }
    }

    @Extension
    public static final class JCloudsSlaveDescriptor
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return "JClouds Slave";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

