/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Descriptor;
import hudson.slaves.RetentionStrategy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.openstack.compute.JCloudsComputer;
import jenkins.plugins.openstack.compute.JCloudsPreCreationThread;
import jenkins.plugins.openstack.compute.JCloudsSlave;
import org.kohsuke.stapler.DataBoundConstructor;

public class JCloudsRetentionStrategy
extends RetentionStrategy<JCloudsComputer> {
    private transient ReentrantLock checkLock;
    private static final Logger LOGGER = Logger.getLogger(JCloudsRetentionStrategy.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL", "Left modifiable from groovy"})
    static boolean disabled = Boolean.getBoolean(JCloudsRetentionStrategy.class.getName() + ".disabled");

    @DataBoundConstructor
    public JCloudsRetentionStrategy() {
        this.readResolve();
    }

    public long check(@Nonnull JCloudsComputer c) {
        if (disabled) {
            LOGGER.fine("Skipping check - disabled");
            return 1L;
        }
        LOGGER.finest("Checking");
        if (!this.checkLock.tryLock()) {
            LOGGER.info("Failed to acquire retention lock - skipping");
            return 1L;
        }
        try {
            this.doCheck(c);
        }
        finally {
            this.checkLock.unlock();
        }
        return 1L;
    }

    private void doCheck(JCloudsComputer c) {
        if (c.isPendingDelete()) {
            return;
        }
        if (c.isConnecting()) {
            return;
        }
        if (!c.isIdle() || c.isUserOffline()) {
            return;
        }
        JCloudsSlave node = c.getNode();
        if (node == null) {
            return;
        }
        int retentionTime = node.getSlaveOptions().getRetentionTime();
        if (retentionTime <= 0) {
            return;
        }
        long idleSince = c.getIdleStart();
        long idleMilliseconds = this.getNow() - idleSince;
        if (idleMilliseconds > TimeUnit.MINUTES.toMillis(retentionTime)) {
            if (JCloudsPreCreationThread.isNeededReadyComputer(node.getComputer())) {
                LOGGER.fine("Keeping " + c.getName() + " to meet minimum requirements");
                return;
            }
            LOGGER.info("Scheduling " + c.getName() + " for termination after " + retentionTime + " minutes as it was idle since " + String.valueOf(new Date(idleSince)));
            if (LOGGER.isLoggable(Level.FINE)) {
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    Jenkins.XSTREAM2.toXMLUTF8((Object)node, (OutputStream)out);
                    LOGGER.fine(out.toString("UTF-8"));
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to dump node config", e);
                }
            }
            c.setPendingDelete(true);
        }
    }

    long getNow() {
        return System.currentTimeMillis();
    }

    public void start(JCloudsComputer c) {
        c.connect(false);
    }

    protected Object readResolve() {
        this.checkLock = new ReentrantLock(false);
        return this;
    }

    public static class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        public String getDisplayName() {
            return "JClouds";
        }
    }
}

