/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import hudson.Extension;
import hudson.Functions;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.openstack.compute.JCloudsCloud;
import jenkins.plugins.openstack.compute.JCloudsComputer;
import jenkins.plugins.openstack.compute.JCloudsSlave;
import jenkins.plugins.openstack.compute.JCloudsSlaveTemplate;
import jenkins.plugins.openstack.compute.SlaveOptions;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public final class JCloudsPreCreationThread
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(JCloudsPreCreationThread.class.getName());

    public JCloudsPreCreationThread() {
        super("OpenStack slave pre-creation");
    }

    public long getRecurrencePeriod() {
        return Functions.getIsUnitTest() ? Long.MAX_VALUE : 120000L;
    }

    public void execute(TaskListener listener) {
        HashMap<JCloudsSlaveTemplate, JCloudsCloud> requiredCapacity = new HashMap<JCloudsSlaveTemplate, JCloudsCloud>();
        for (JCloudsCloud jCloudsCloud : JCloudsCloud.getClouds()) {
            for (JCloudsSlaveTemplate template : jCloudsCloud.getTemplates()) {
                SlaveOptions to = template.getEffectiveSlaveOptions();
                if (to.getInstancesMin() <= 0) continue;
                requiredCapacity.put(template, jCloudsCloud);
            }
        }
        if (requiredCapacity.isEmpty()) {
            return;
        }
        for (Map.Entry entry : requiredCapacity.entrySet()) {
            int runningNodes;
            JCloudsSlaveTemplate template;
            JCloudsCloud cloud = (JCloudsCloud)entry.getValue();
            template = (JCloudsSlaveTemplate)entry.getKey();
            SlaveOptions so = template.getEffectiveSlaveOptions();
            Integer min = so.getInstancesMin();
            Integer cap = so.getInstanceCap();
            int available = template.getAvailableNodesTotal();
            if (available >= min || available >= cap || (runningNodes = template.getRunningNodes().size()) >= cap) continue;
            int permitted = cap - runningNodes;
            int desired = min - available;
            int toProvision = Math.min(desired, permitted);
            if (toProvision <= 0) continue;
            LOGGER.log(Level.INFO, "Pre-creating " + toProvision + " instance(s) for template " + template.getName() + " in cloud " + cloud.name);
            for (int i = 0; i < toProvision; ++i) {
                try {
                    cloud.provisionSlaveExplicitly(template);
                    continue;
                }
                catch (Throwable ex) {
                    LOGGER.log(Level.SEVERE, "Failed to pre-create instance from template " + template.getName(), ex);
                }
            }
        }
    }

    static boolean isNeededReadyComputer(JCloudsComputer computer) {
        String templateName;
        JCloudsCloud cloud;
        JCloudsSlaveTemplate template;
        if (computer == null) {
            return false;
        }
        JCloudsSlave node = computer.getNode();
        if (node == null) {
            return false;
        }
        Integer instancesMin = node.getSlaveOptions().getInstancesMin();
        if (instancesMin > 0 && (template = (cloud = JCloudsCloud.getByName(computer.getId().getCloudName())).getTemplate(templateName = computer.getId().getTemplateName())) != null) {
            int readyNodes = template.getAvailableNodesTotal();
            return readyNodes <= instancesMin;
        }
        return false;
    }

    protected Level getNormalLoggingLevel() {
        return Level.FINE;
    }

    protected Level getSlowLoggingLevel() {
        return Level.INFO;
    }
}

