/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.plugins.openstack.compute.JCloudsComputer;
import org.kohsuke.stapler.DataBoundConstructor;

public class JCloudsOneOffSlave
extends BuildWrapper {
    private static final Logger LOGGER = Logger.getLogger(JCloudsOneOffSlave.class.getName());

    @DataBoundConstructor
    public JCloudsOneOffSlave() {
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) {
        Computer c;
        Executor executor = build.getExecutor();
        if (executor != null && (c = executor.getOwner()) instanceof JCloudsComputer) {
            return new BuildWrapper.Environment(){

                public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                    ((JCloudsComputer)c).setPendingDelete(true);
                    return true;
                }
            };
        }
        return new BuildWrapper.Environment(){};
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return "OpenStack Single-Use Slave";
        }

        public boolean isApplicable(AbstractProject item) {
            return true;
        }
    }
}

