/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Queue;
import hudson.remoting.Channel;
import hudson.security.Permission;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.plugins.openstack.compute.JCloudsRetentionStrategy;
import jenkins.plugins.openstack.compute.JCloudsSlave;
import jenkins.plugins.openstack.compute.Messages;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedItem;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class JCloudsComputer
extends AbstractCloudComputer<JCloudsSlave>
implements TrackedItem {
    private static final Logger LOGGER = Logger.getLogger(JCloudsComputer.class.getName());
    private final ProvisioningActivity.Id provisioningId;
    private volatile AtomicInteger used = new AtomicInteger(0);
    private transient long connectedSince;

    @Nonnull
    public static List<JCloudsComputer> getAll() {
        ArrayList<JCloudsComputer> out = new ArrayList<JCloudsComputer>();
        for (Computer c : Jenkins.get().getComputers()) {
            if (!(c instanceof JCloudsComputer)) continue;
            out.add((JCloudsComputer)c);
        }
        return out;
    }

    public JCloudsComputer(JCloudsSlave slave) {
        super((AbstractCloudSlave)slave);
        this.provisioningId = slave.getId();
    }

    @CheckForNull
    public JCloudsSlave getNode() {
        return (JCloudsSlave)super.getNode();
    }

    @Nonnull
    public ProvisioningActivity.Id getId() {
        return this.provisioningId;
    }

    public void setPendingDelete(boolean newVal) {
        boolean is = this.isPendingDelete();
        if (is == newVal) {
            return;
        }
        LOGGER.info("Setting " + this.getName() + " pending delete status to " + newVal);
        this.setTemporarilyOffline(newVal, (OfflineCause)(newVal ? new PendingTermination() : null));
    }

    public boolean isPendingDelete() {
        return this.getOfflineCause() instanceof PendingTermination;
    }

    boolean isUserOffline() {
        return this.getOfflineCause() instanceof OfflineCause.UserCause;
    }

    public JCloudsRetentionStrategy getRetentionStrategy() {
        RetentionStrategy rs = super.getRetentionStrategy();
        if (rs instanceof JCloudsRetentionStrategy) {
            return (JCloudsRetentionStrategy)rs;
        }
        return new JCloudsRetentionStrategy();
    }

    private int getRetentionTime() {
        JCloudsSlave node = this.getNode();
        if (node == null) {
            return -1;
        }
        return node.getSlaveOptions().getRetentionTime();
    }

    public boolean isAcceptingTasks() {
        if (this.getRetentionTime() == 0 && this.used.get() > 1) {
            return false;
        }
        return super.isAcceptingTasks();
    }

    int getTasksExecuted() {
        return this.used.get();
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        super.taskCompleted(executor, task, durationMS);
        this.checkSlaveAfterTaskCompletion();
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        super.taskCompletedWithProblems(executor, task, durationMS, problems);
        this.checkSlaveAfterTaskCompletion();
    }

    private void checkSlaveAfterTaskCompletion() {
        this.used.incrementAndGet();
        if (this.getRetentionTime() == 0 && !this.isUserOffline()) {
            this.setPendingDelete(true);
        }
    }

    @Restricted(value={DoNotUse.class})
    public void doConfigure(StaplerResponse rsp) throws IOException {
        rsp.sendError(404);
    }

    @Restricted(value={NoExternalUse.class})
    @RequirePOST
    public HttpResponse doDoDelete() {
        this.checkPermission(Permission.DELETE);
        try {
            this.deleteSlave();
            return new HttpRedirect("..");
        }
        catch (Exception ex) {
            return HttpResponses.error((int)500, (Throwable)ex);
        }
    }

    @Restricted(value={NoExternalUse.class})
    @RequirePOST
    public HttpRedirect doScheduleTermination() {
        this.checkPermission(Permission.DELETE);
        this.setPendingDelete(true);
        return new HttpRedirect(".");
    }

    void deleteSlave() throws IOException, InterruptedException {
        JCloudsSlave slave = this.getNode();
        if (slave == null) {
            return;
        }
        LOGGER.info("Deleting slave " + this.getName() + " after executing " + this.getTasksExecuted() + " builds");
        this.setAcceptingTasks(false);
        try {
            slave.terminate();
            LOGGER.info("Deleted slave " + this.getName());
        }
        catch (Throwable ex) {
            this.setAcceptingTasks(true);
            throw ex;
        }
    }

    public void setChannel(Channel channel, OutputStream launchLog, Channel.Listener listener) throws IOException, InterruptedException {
        super.setChannel(channel, launchLog, listener);
        this.connectedSince = System.currentTimeMillis();
    }

    public long getConnectedSince() {
        return this.connectedSince;
    }

    long getIdleStart() {
        long idleStart = super.getIdleStartMilliseconds();
        if (this.connectedSince == 0L) {
            return System.currentTimeMillis();
        }
        return Math.max(this.connectedSince, idleStart);
    }

    private static final class PendingTermination
    extends OfflineCause.SimpleOfflineCause {
        private PendingTermination() {
            super(Messages._DeletedCause());
        }
    }
}

